/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@Deprecated
public class CreateSubset {
    private static String[] SubsetTables = new String[]{"OS/2", "cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "name", "prep"};
    private static final int ARG_1_AND_2_ARE_WORDS = 1;
    private static final int WE_HAVE_A_SCALE = 8;
    private static final int MORE_COMPONENTS = 32;
    private static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final int WE_HAVE_A_TWO_BY_TWO = 128;
    private final TTFont font;
    private final Set glyphIndices;
    private TTFont result;

    public CreateSubset(TTFont font, Set glyphIndices) {
        this.font = font;
        this.glyphIndices = glyphIndices;
    }

    protected Set addCompositeGlyphs(TTInput glyfInput, long[] locations, Set glyphs) throws IOException, TTException {
        HashSet allGlyphs = new HashSet();
        allGlyphs.addAll(glyphs);
        Iterator i = glyphs.iterator();
        while (i.hasNext()) {
            int codePoint = (Integer)i.next();
            this.addCompositeGlyphs(glyfInput, locations, allGlyphs, codePoint);
        }
        return allGlyphs;
    }

    protected void addCompositeGlyphs(TTInput glyfInput, long[] locations, Set glyphs, int codePoint) throws IOException, TTException {
        if (locations[codePoint] == locations[codePoint + 1]) {
            return;
        }
        glyfInput.seek(locations[codePoint]);
        short numContours = glyfInput.readInt16();
        if (numContours >= 0) {
            return;
        }
        glyfInput.seekBy(8L);
        while (true) {
            int flags = glyfInput.readUInt16();
            int codePointRef = glyfInput.readUInt16();
            glyphs.add(codePointRef);
            if ((flags & 0x20) == 0) {
                return;
            }
            int skip = (flags & 1) != 0 ? 4 : 2;
            if ((flags & 8) != 0) {
                skip += 2;
            } else if ((flags & 0x40) != 0) {
                skip += 4;
            }
            if ((flags & 0x80) != 0) {
                skip += 8;
            }
            glyfInput.seekBy(skip);
        }
    }

    public TTFont compute() throws IOException, TTException {
        long[] locations = this.getFont().getIndexToLocation().getOffsets();
        TTTable loca = this.getFont().getTable("loca");
        TTTable glyf = this.getFont().getTable("glyf");
        try (TTInput glyfInput = glyf.getInput();){
            this.result = this.copySubset();
            this.getGlyphIndices().add(0);
            Set compositeGlyphs = this.addCompositeGlyphs(glyfInput, locations, this.getGlyphIndices());
            short indexToLocFormat = this.getFont().getFontHeader().getIndexToLocFormat();
            this.createGlyphTable(loca, glyf, glyfInput, locations, compositeGlyphs, indexToLocFormat == 0);
            TTFont tTFont = this.result;
            return tTFont;
        }
    }

    protected TTFont copySubset() {
        TTFont resultFont = new TTFont(65536);
        for (int i = 0; i < SubsetTables.length; ++i) {
            TTTable table = this.getFont().getTable(SubsetTables[i]);
            if (table == null) continue;
            resultFont.putTable(table);
        }
        return resultFont;
    }

    protected void createGlyphTable(TTTable loca, TTTable glyf, TTInput glyphInput, long[] oldLocations, Set glyphs, boolean shortFormat) throws IOException, TTException {
        int newLength = 0;
        Iterator i = glyphs.iterator();
        while (i.hasNext()) {
            int codePoint = (Integer)i.next();
            if (codePoint + 1 >= oldLocations.length) continue;
            newLength = (int)((long)newLength + (oldLocations[codePoint + 1] - oldLocations[codePoint]));
        }
        newLength = newLength + 3 & 0xFFFFFFFC;
        int[] newLocations = new int[oldLocations.length];
        byte[] newGlyfData = new byte[newLength];
        int ptr = 0;
        for (int i2 = 0; i2 < oldLocations.length; ++i2) {
            long glyfstart;
            int glyflength;
            newLocations[i2] = ptr;
            if (!glyphs.contains(i2) || (glyflength = (int)(oldLocations[i2 + 1] - (glyfstart = oldLocations[i2]))) <= 0) continue;
            glyphInput.seek(glyfstart);
            glyphInput.readFully(newGlyfData, ptr, glyflength);
            ptr += glyflength;
        }
        RandomAccessByteArray random = new RandomAccessByteArray(null);
        this.write_loca((IRandomAccess)random, newLocations, shortFormat);
        loca.setBytes(random.toByteArray());
        glyf.setBytes(newGlyfData);
    }

    public TTFont getFont() {
        return this.font;
    }

    public Set getGlyphIndices() {
        return this.glyphIndices;
    }

    public TTFont getResult() {
        return this.result;
    }

    public void write_loca(IRandomAccess random, int[] locations, boolean shortFormat) throws IOException {
        for (int location : locations) {
            if (shortFormat) {
                random.write((int)((byte)((location /= 2) >> 8)));
                random.write((int)((byte)location));
                continue;
            }
            random.write((int)((byte)(location >> 24)));
            random.write((int)((byte)(location >> 16)));
            random.write((int)((byte)(location >> 8)));
            random.write((int)((byte)location));
        }
    }
}

