/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTCMap;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTOutput;
import de.intarsys.cwt.font.truetype.TTSerializable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTCharacterToGlyphIndexMapping
implements TTSerializable {
    private static final Logger Log = LoggerFactory.getLogger(TTCharacterToGlyphIndexMapping.class);
    private static final int[][] PREFERRED_CMAP_IDS = new int[][]{{3, 1}, {3, 0}, {1, 0}, {0, 4}, {0, 3}};
    private static final Comparator<TTCMap> SERIALIZED_ORDER = Comparator.comparing(TTCMap::getPlatformId).thenComparing(TTCMap::getEncodingId);
    private Collection<TTCMap> cmaps = new ArrayList<TTCMap>();

    public TTCMap getCMap(int platformId, int encodingId) {
        return this.cmaps.stream().filter(c -> c.getPlatformId() == platformId).filter(c -> c.getEncodingId() == encodingId).findAny().orElse(null);
    }

    public Collection<TTCMap> getCMaps() {
        return new ArrayList<TTCMap>(this.cmaps);
    }

    public TTCMap getPreferredCMap() {
        Stream<TTCMap> preferredCMaps = Stream.of(PREFERRED_CMAP_IDS).map(id -> this.getCMap(id[0], id[1])).filter(Objects::nonNull);
        Stream<TTCMap> allCMaps = this.cmaps.stream();
        return Stream.concat(preferredCMaps, allCMaps).findFirst().orElse(null);
    }

    @Override
    public String getTag() {
        return "cmap";
    }

    public void putCMap(TTCMap cmap) {
        this.removeCMap(cmap.getPlatformId(), cmap.getEncodingId());
        this.cmaps.add(cmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void read(TTFont font, TTInput input) throws IOException {
        input.readUInt16();
        numTables = input.readUInt16();
        for (i = 0; i < numTables; ++i) {
            platformId = input.readUInt16();
            encodingId = input.readUInt16();
            offset = input.readUInt32();
            cidToGid /* !! */  = new HashMap<K, V>();
            mark = input.getOffset();
            try {
                input.seek(offset);
                format = input.readUInt16();
                switch (format) {
                    case 0: {
                        cidToGid /* !! */  = this.readFormat0(input);
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        cidToGid /* !! */  = this.readFormat4(input);
                        ** break;
lbl21:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        cidToGid /* !! */  = this.readFormat6(input);
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    default: {
                        TTCharacterToGlyphIndexMapping.Log.warn("font {} with unsupported format {} in cmap {}:{}", new Object[]{font.getLocator(), format, platformId, encodingId});
                        cidToGid /* !! */  = Collections.emptyMap();
                        break;
                    }
                }
            }
            finally {
                input.seek(mark);
            }
            this.putCMap(new TTCMap(platformId, encodingId, cidToGid /* !! */ ));
        }
    }

    private Map<Integer, Integer> readFormat0(TTInput input) throws IOException {
        input.readUInt16();
        input.readUInt16();
        HashMap<Integer, Integer> cidToGid = new HashMap<Integer, Integer>();
        for (int characterCode = 0; characterCode < 256; ++characterCode) {
            int glyphId = input.readUInt8();
            cidToGid.put(characterCode, glyphId);
        }
        return cidToGid;
    }

    private Map<Integer, Integer> readFormat4(TTInput input) throws IOException {
        int length = input.readUInt16();
        input.readUInt16();
        int segCount = input.readUInt16() / 2;
        input.readUInt16();
        input.readUInt16();
        input.readUInt16();
        int[] endCount = input.readUInt16Array(segCount);
        input.readUInt16();
        int[] startCount = input.readUInt16Array(segCount);
        int[] idDelta = input.readUInt16Array(segCount);
        int[] idRangeOffset = input.readUInt16Array(segCount);
        int glyphIdCount = length / 2 - 8 - segCount * 4;
        int[] glyphIds = input.readUInt16Array(glyphIdCount);
        HashMap<Integer, Integer> cidToGid = new HashMap<Integer, Integer>();
        for (int i = 0; i < segCount; ++i) {
            int characterCode;
            int start = startCount[i];
            int end = endCount[i];
            if (start == 65535 || end == 65535) continue;
            int delta = idDelta[i];
            int rangeOffset = idRangeOffset[i];
            if (rangeOffset == 0) {
                for (characterCode = start; characterCode <= end; ++characterCode) {
                    int glyphId = characterCode + delta & 0xFFFF;
                    cidToGid.put(characterCode, glyphId);
                }
                continue;
            }
            for (characterCode = start; characterCode <= end; ++characterCode) {
                int index = rangeOffset / 2 + (characterCode - start) - segCount + i;
                int glyphId = glyphIds[index];
                if (glyphId != 0) {
                    glyphId = glyphId + delta & 0xFFFF;
                }
                cidToGid.put(characterCode, glyphId);
            }
        }
        return cidToGid;
    }

    private Map<Integer, Integer> readFormat6(TTInput input) throws IOException {
        input.readUInt16();
        input.readUInt16();
        HashMap<Integer, Integer> cidToGid = new HashMap<Integer, Integer>();
        int firstCode = input.readUInt16();
        int entryCount = input.readUInt16();
        int lastCode = firstCode + entryCount;
        for (int character = firstCode; character < lastCode; ++character) {
            int glyphId = input.readUInt16();
            cidToGid.put(character, glyphId);
        }
        return cidToGid;
    }

    public void removeCMap(int platformId, int encodingId) {
        TTCMap cmap = this.getCMap(platformId, encodingId);
        if (cmap != null) {
            this.cmaps.remove(cmap);
        }
    }

    public void removeCMap(TTCMap cmap) {
        this.cmaps.remove(cmap);
    }

    @Override
    public void write(TTOutput output) throws IOException {
        output.writeUInt16(0);
        output.writeUInt16(this.cmaps.size());
        ArrayList<TTCMap> sortedCMaps = new ArrayList<TTCMap>(this.cmaps);
        sortedCMaps.sort(SERIALIZED_ORDER);
        long offset = 4 + this.cmaps.size() * 8;
        ByteArrayOutputStream subtables = new ByteArrayOutputStream();
        try (TTOutput subtablesOutput = new TTOutput(subtables);){
            for (TTCMap cmap : sortedCMaps) {
                output.writeUInt16(cmap.getPlatformId());
                output.writeUInt16(cmap.getEncodingId());
                output.writeUInt32(offset + (long)subtables.size());
                this.writeFormat4(subtablesOutput, cmap);
            }
        }
        output.write(subtables.toByteArray());
    }

    private void writeFormat4(TTOutput output, TTCMap cmap) throws IOException {
        Map<Integer, Integer> cidToGid = cmap.getCidToGid();
        if (cidToGid.isEmpty()) {
            throw new IOException("cmap is empty!");
        }
        int[] cids = cidToGid.keySet().stream().mapToInt(Integer::intValue).sorted().toArray();
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int i = 0;
        while (i < cids.length) {
            int end;
            int start = cids[i];
            do {
                end = cids[i];
            } while (++i < cids.length && cids[i] <= end + 1);
            segments.add(new Segment(start, end));
        }
        int gidCount = 0;
        int segmentIndex = 0;
        int segmentCount = segments.size() + 1;
        for (Segment segment : segments) {
            int cid;
            int delta = cidToGid.get(cid) - cid;
            for (cid = segment.start; cid <= segment.end && delta == cidToGid.get(cid) - cid; ++cid) {
            }
            if (cid > segment.end) {
                segment.delta = delta;
            } else {
                segment.rangeOffset = (gidCount + (segmentCount - segmentIndex)) * 2;
                gidCount += segment.end - segment.start + 1;
            }
            ++segmentIndex;
        }
        Segment dummy = new Segment(65535, 65535);
        dummy.delta = 1;
        segments.add(dummy);
        int length = (8 + 4 * segmentCount + gidCount) * 2;
        int searchRange = 2 * Integer.highestOneBit(segmentCount);
        int entrySelector = 31 - Integer.numberOfLeadingZeros(searchRange) - 1;
        output.writeUInt16(4);
        output.writeUInt16(length);
        output.writeUInt16(0);
        output.writeUInt16(2 * segmentCount);
        output.writeUInt16(searchRange);
        output.writeUInt16(entrySelector);
        output.writeUInt16(2 * segmentCount - searchRange);
        for (Segment segment : segments) {
            output.writeUInt16(segment.end);
        }
        output.writeUInt16(0);
        for (Segment segment : segments) {
            output.writeUInt16(segment.start);
        }
        for (Segment segment : segments) {
            output.writeUInt16(segment.delta);
        }
        for (Segment segment : segments) {
            output.writeUInt16(segment.rangeOffset);
        }
        for (Segment segment : segments) {
            if (segment.rangeOffset == 0) continue;
            for (int cid = segment.start; cid <= segment.end; ++cid) {
                output.writeUInt16(cidToGid.get(cid));
            }
        }
    }

    private static class Segment {
        public int start;
        public int end;
        public int delta;
        public int rangeOffset;

        public Segment(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return String.format("(start=%d, end=%d, delta=%d, rangeOffset=%d)", this.start, this.end, this.delta, this.rangeOffset);
        }
    }
}

