/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.truetype.TTCharacterToGlyphIndexMapping;
import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFontHeader;
import de.intarsys.cwt.font.truetype.TTHorizontalHeader;
import de.intarsys.cwt.font.truetype.TTHorizontalMetrics;
import de.intarsys.cwt.font.truetype.TTIndexToLocation;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTMaximumProfile;
import de.intarsys.cwt.font.truetype.TTMetrics;
import de.intarsys.cwt.font.truetype.TTNaming;
import de.intarsys.cwt.font.truetype.TTOutput;
import de.intarsys.cwt.font.truetype.TTPostScriptInformation;
import de.intarsys.cwt.font.truetype.TTSerializable;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TTFont {
    public static final int SFNT_TRUE_TYPE = 65536;
    public static final int SFNT_OPEN_TYPE = 0x4F54544F;
    public static final int TRUE_TYPE_COLLECTION_TAG = 1953784678;
    private ILocator locator;
    private int sfntVersion;
    private String fontFamilyName = null;
    private FontStyle fontStyle = FontStyle.REGULAR;
    private String postScriptName = null;
    private Map<String, TTTable> tables = new TreeMap<String, TTTable>();
    private Map<Class<?>, TTSerializable> cache = new HashMap();

    public static TTFont createFromLocator(ILocator locator) throws IOException, TTException {
        try (TTInput input = new TTInput(locator.getRandomAccess());){
            int sfntVersion = input.readInt32();
            if (sfntVersion == 1953784678) {
                throw new TTException("font resource is a TrueType Collection");
            }
            int numTables = input.readUInt16();
            input.readUInt16();
            input.readUInt16();
            input.readUInt16();
            TTFont font = new TTFont(sfntVersion, locator);
            for (int i = 0; i < numTables; ++i) {
                String name = new String(input.readFully(4), StandardCharsets.US_ASCII);
                int checksum = input.readInt32();
                long offset = input.readUInt32();
                long length = input.readUInt32();
                TTTable table = new TTTable(font, name, offset, length, checksum);
                font.putTable(table);
            }
            TTNaming naming = font.getNaming();
            if (naming != null) {
                String fontFamilyName = naming.getName(1);
                String subfamilyName = naming.getName(2);
                FontStyle fontStyle = FontStyle.getFontStyle((String)subfamilyName);
                Object postScriptName = naming.getName(6);
                if (postScriptName == null) {
                    postScriptName = fontFamilyName + "-" + fontStyle.getId();
                }
                font.setFontFamilyName(fontFamilyName);
                font.setPostScriptName((String)postScriptName);
                font.setFontStyle(fontStyle);
            }
            TTFont tTFont = font;
            return tTFont;
        }
    }

    public TTFont(int sfntVersion, ILocator locator) {
        this(sfntVersion);
        this.locator = locator;
    }

    public TTFont(int sfntVersion) {
        this.sfntVersion = sfntVersion;
    }

    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public void setFontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
    }

    public String getFontName() {
        return this.getPostScriptName();
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getPostScriptName() {
        return this.postScriptName;
    }

    public void setPostScriptName(String postScriptName) {
        this.postScriptName = postScriptName;
    }

    public int getSfntVersion() {
        return this.sfntVersion;
    }

    public TTCharacterToGlyphIndexMapping getCharacterToGlyphIndexMapping() throws TTException {
        return this.getCached(TTCharacterToGlyphIndexMapping.class, false);
    }

    public TTFontHeader getFontHeader() throws TTException {
        return this.getCached(TTFontHeader.class, true);
    }

    public TTHorizontalHeader getHorizontalHeader() throws TTException {
        return this.getCached(TTHorizontalHeader.class, true);
    }

    public TTHorizontalMetrics getHorizontalMetrics() throws TTException {
        return this.getCached(TTHorizontalMetrics.class, true);
    }

    public TTIndexToLocation getIndexToLocation() throws TTException {
        return this.getCached(TTIndexToLocation.class, true);
    }

    public TTMaximumProfile getMaximumProfile() throws TTException {
        return this.getCached(TTMaximumProfile.class, true);
    }

    public TTMetrics getMetrics() throws TTException {
        return this.getCached(TTMetrics.class, false);
    }

    public TTNaming getNaming() throws TTException {
        return this.getCached(TTNaming.class, false);
    }

    public TTPostScriptInformation getPostScriptInformation() throws TTException {
        return this.getCached(TTPostScriptInformation.class, false);
    }

    public boolean isEmbeddingPermitted() throws TTException {
        TTMetrics metrics = this.getMetrics();
        return metrics == null || metrics.isEmbeddingPermitted();
    }

    public boolean isSubsettingPermitted() throws TTException {
        TTMetrics metrics = this.getMetrics();
        return metrics == null || metrics.isSubsettingPermitted();
    }

    private <S extends TTSerializable> S getCached(Class<S> type, boolean required) throws TTException {
        TTSerializable serializable = (TTSerializable)type.cast(this.cache.get(type));
        if (serializable == null) {
            serializable = this.get(type);
            this.cache.put(type, serializable);
        }
        if (required && serializable == null) {
            throw new TTException("Missing required table for " + type.getSimpleName());
        }
        return (S)serializable;
    }

    public <S extends TTSerializable> S get(Class<S> type) throws TTException {
        TTSerializable serializable;
        try {
            serializable = (TTSerializable)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            throw new TTException("Internal error", exception);
        }
        String tag = serializable.getTag();
        TTTable table = this.getTable(tag);
        if (table == null) {
            return null;
        }
        try (TTInput input = table.getInput();){
            serializable.read(this, input);
        }
        catch (IOException exception) {
            throw new TTException("Failed to deserialize table: " + tag, exception);
        }
        return (S)serializable;
    }

    public <S extends TTSerializable> void put(S serializable) throws TTException {
        String tag = serializable.getTag();
        TTTable table = new TTTable(tag);
        try (TTOutput output = table.getOutput();){
            serializable.write(output);
            this.putTable(table);
        }
        catch (IOException exception) {
            throw new TTException("Failed to serialize table: " + tag, exception);
        }
    }

    public <S extends TTSerializable> S remove(Class<S> type) throws TTException {
        S serializable = this.get(type);
        if (serializable != null) {
            this.tables.remove(serializable.getTag());
            this.cache.remove(type);
        }
        return serializable;
    }

    public TTTable getTable(String tag) {
        return this.tables.get(tag);
    }

    public void putTable(TTTable table) {
        this.tables.put(table.getTag(), table);
    }

    public TTTable removeTable(String tag) {
        return this.tables.remove(tag);
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public List<TTTable> getTables() {
        return new ArrayList<TTTable>(this.tables.values());
    }

    public String toString() {
        return String.format("TrueType font '%s' (family=%s, style=%s)", this.postScriptName, this.fontFamilyName, this.fontStyle);
    }
}

