/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTOutput;
import de.intarsys.cwt.font.truetype.TTTable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TTFontSerializer {
    public void write(OutputStream outputStream, TTFont font) throws IOException {
        TTOutput output = new TTOutput(outputStream);
        long fontChecksum = this.writeOffsetTable(output, font.getSfntVersion(), font.getTableCount());
        List<TTTable> tables = font.getTables();
        ArrayList<byte[]> tableData = new ArrayList<byte[]>(tables.size());
        byte[] headTableData = null;
        long offset = 12L + (long)tables.size() * 16L;
        for (TTTable table : tables) {
            byte[] data = this.getData(table);
            tableData.add(data);
            String name = table.getTag();
            if ("head".equals(name)) {
                headTableData = data;
                Arrays.fill(headTableData, 8, 12, (byte)0);
            }
            long length = table.getLength();
            long checksum = this.computeChecksum(data);
            fontChecksum += this.writeTableRecord(output, name, offset, length, checksum);
            fontChecksum += checksum;
            offset += length + 3L & 0xFFFFFFFFFFFFFFFCL;
        }
        if (headTableData != null) {
            long checksumAdjustment = 2981146554L - (fontChecksum & 0xFFFFFFFFL);
            headTableData[8] = (byte)(checksumAdjustment >> 24);
            headTableData[9] = (byte)(checksumAdjustment >> 16);
            headTableData[10] = (byte)(checksumAdjustment >> 8);
            headTableData[11] = (byte)checksumAdjustment;
        }
        for (byte[] data : tableData) {
            this.writeTableData(output, data);
        }
    }

    private byte[] getData(TTTable table) throws IOException {
        int length = (int)table.getLength();
        int paddedLength = length + 3 & 0xFFFFFFFC;
        byte[] data = new byte[paddedLength];
        try (TTInput input = table.getInput();){
            input.readFully(data, 0, length);
        }
        return data;
    }

    private long writeOffsetTable(TTOutput output, int sfntVersion, int numTables) throws IOException {
        int searchRange = Integer.highestOneBit(numTables) * 16;
        int entrySelector = 31 - Integer.numberOfLeadingZeros(numTables);
        int rangeShift = numTables * 16 - searchRange;
        output.writeUInt32(sfntVersion);
        output.writeUInt16(numTables);
        output.writeUInt16(searchRange);
        output.writeUInt16(entrySelector);
        output.writeUInt16(rangeShift);
        return this.toUInt32(sfntVersion) + this.toUInt32(numTables, searchRange) + this.toUInt32(entrySelector, rangeShift);
    }

    private long writeTableRecord(TTOutput output, String name, long offset, long length, long checksum) throws IOException {
        byte[] tag = name.getBytes(StandardCharsets.US_ASCII);
        output.write(tag, 0, tag.length);
        output.writeUInt32(checksum);
        output.writeUInt32(offset);
        output.writeUInt32(length);
        return this.computeChecksum(tag) + checksum + offset + length;
    }

    private void writeTableData(TTOutput output, byte[] bytes) throws IOException {
        output.write(bytes, 0, bytes.length);
    }

    public long computeChecksum(byte[] bytes) {
        long checksum = 0L;
        for (int i = 0; i < bytes.length; i += 4) {
            checksum += ((long)bytes[i] & 0xFFL) << 24 | ((long)bytes[i + 1] & 0xFFL) << 16 | ((long)bytes[i + 2] & 0xFFL) << 8 | (long)bytes[i + 3] & 0xFFL;
        }
        return checksum;
    }

    private long toUInt32(int int32) {
        return (long)int32 & 0xFFFFFFFFL;
    }

    private long toUInt32(int high16, int low16) {
        return ((long)high16 & 0xFFFFL) << 16 | (long)low16 & 0xFFFFL;
    }
}

