/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTCMap;
import de.intarsys.cwt.font.truetype.TTCharacterToGlyphIndexMapping;
import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontHeader;
import de.intarsys.cwt.font.truetype.TTHorizontalHeader;
import de.intarsys.cwt.font.truetype.TTHorizontalMetrics;
import de.intarsys.cwt.font.truetype.TTIndexToLocation;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTMaximumProfile;
import de.intarsys.cwt.font.truetype.TTMetrics;
import de.intarsys.cwt.font.truetype.TTNameRecord;
import de.intarsys.cwt.font.truetype.TTNaming;
import de.intarsys.cwt.font.truetype.TTOutput;
import de.intarsys.cwt.font.truetype.TTSerializable;
import de.intarsys.cwt.font.truetype.TTTable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class TTFontSubsetter {
    private static final List<String> MANDATORY_TABLE_TAGS = List.of("cvt ", "fpgm", "prep");
    private static final int ARG_1_AND_2_ARE_WORDS = 1;
    private static final int WE_HAVE_A_SCALE = 8;
    private static final int MORE_COMPONENTS = 32;
    private static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final int WE_HAVE_A_TWO_BY_TWO = 128;
    private TTFont font;
    private List<Integer> gids;
    private List<String> tagsToRetain;
    private List<TTSerializable> serializablesToAdd;

    public static Builder builder(TTFont font) {
        return new Builder(font);
    }

    private static <T> Map<T, Integer> enumerate(Iterable<T> iterable) {
        HashMap<T, Integer> map = new HashMap<T, Integer>();
        int i = 0;
        for (T element : iterable) {
            map.put(element, i);
            ++i;
        }
        return map;
    }

    public TTFontSubsetter(TTFont font, Collection<Integer> gids, Collection<String> tagsToRetain, Collection<TTSerializable> serializablesToAdd) {
        this.font = font;
        this.gids = List.copyOf(gids);
        this.tagsToRetain = Stream.concat(tagsToRetain.stream(), MANDATORY_TABLE_TAGS.stream()).distinct().toList();
        this.serializablesToAdd = List.copyOf(serializablesToAdd);
    }

    public TTFont createSubset() throws TTException, IOException {
        if (!this.isSubsettingPermitted()) {
            throw new TTException("Subsetting is not permitted");
        }
        TTFont fontSubset = new TTFont(65536);
        for (String tag : this.tagsToRetain) {
            TTTable table = this.font.getTable(tag);
            if (table == null) continue;
            fontSubset.putTable(table);
        }
        ArrayList<Integer> allGids = new ArrayList<Integer>(this.gids);
        TTTable oldGlyf = this.font.getTable("glyf");
        long[] oldOffsets = this.get(TTIndexToLocation.class).getOffsets();
        TTTable newGlyf = new TTTable("glyf");
        ArrayList<Long> newOffsets = new ArrayList<Long>();
        try (TTInput input = oldGlyf.getInput();
             TTOutput output = newGlyf.getOutput();){
            this.pruneGlyphTable(input, oldOffsets, allGids, output, newOffsets);
        }
        fontSubset.putTable(newGlyf);
        TTIndexToLocation indexToLocation = new TTIndexToLocation();
        indexToLocation.setShortFormat(true);
        indexToLocation.setOffsets(newOffsets.stream().mapToLong(Long::longValue).toArray());
        fontSubset.put(indexToLocation);
        TTFontHeader fontHeader = this.get(TTFontHeader.class);
        fontHeader.setIndexToLocFormat((short)0);
        fontSubset.put(fontHeader);
        TTHorizontalMetrics horizontalMetrics = this.get(TTHorizontalMetrics.class);
        this.pruneHorizontalMetrics(horizontalMetrics, allGids);
        fontSubset.put(horizontalMetrics);
        TTHorizontalHeader horizontalHeader = this.get(TTHorizontalHeader.class);
        horizontalHeader.setNumberOfHMetrics(horizontalMetrics.getNumberOfHMetrics());
        fontSubset.put(horizontalHeader);
        TTMaximumProfile maximumProfile = this.get(TTMaximumProfile.class);
        maximumProfile.setNumGlyphs(allGids.size());
        fontSubset.put(maximumProfile);
        TTNaming oldNaming = this.get(TTNaming.class);
        TTNaming newNaming = this.pruneNames(oldNaming);
        fontSubset.put(newNaming);
        for (TTSerializable serializable : this.serializablesToAdd) {
            fontSubset.put(serializable);
        }
        return fontSubset;
    }

    private <S extends TTSerializable> S get(Class<S> type) throws TTException {
        S serializable = this.font.get(type);
        if (serializable == null) {
            throw new TTException("Missing table " + type.getSimpleName());
        }
        return serializable;
    }

    public boolean isSubsettingPermitted() throws TTException {
        TTMetrics metrics = this.font.getMetrics();
        return metrics == null || metrics.isSubsettingPermitted();
    }

    private void pruneGlyphTable(TTInput input, long[] offsets, List<Integer> gids, TTOutput output, List<Long> newOffsets) throws IOException {
        Map<Integer, Integer> oldToNewGid = TTFontSubsetter.enumerate(gids);
        long newOffset = 0L;
        ArrayDeque<Integer> toDo = new ArrayDeque<Integer>(gids);
        while (!toDo.isEmpty()) {
            long offset;
            newOffsets.add(newOffset);
            int gid = (Integer)toDo.poll();
            long length = offsets[gid + 1] - (offset = offsets[gid]);
            if (length <= 0L) continue;
            input.seek(offset);
            byte[] glyph = input.readFully((int)length);
            if (glyph[0] < 0) {
                int flags;
                int i = 10;
                do {
                    int reference;
                    flags = (glyph[i] & 0xFF) << 8 | glyph[i + 1] & 0xFF;
                    if (!oldToNewGid.containsKey(reference = (glyph[i += 2] & 0xFF) << 8 | glyph[i + 1] & 0xFF)) {
                        oldToNewGid.put(reference, gids.size());
                        gids.add(reference);
                        toDo.offer(reference);
                    }
                    int newReference = oldToNewGid.get(reference);
                    glyph[i] = (byte)(newReference >> 8);
                    glyph[i + 1] = (byte)newReference;
                    i += 2;
                    i = (flags & 1) != 0 ? (i += 4) : (i += 2);
                    if ((flags & 8) != 0) {
                        i += 2;
                        continue;
                    }
                    if ((flags & 0x40) != 0) {
                        i += 4;
                        continue;
                    }
                    if ((flags & 0x80) == 0) continue;
                    i += 8;
                } while ((flags & 0x20) != 0);
            }
            output.write(glyph);
            newOffset += length;
            while ((newOffset & 3L) != 0L) {
                output.writeUInt8(0);
                ++newOffset;
            }
        }
        newOffsets.add(newOffset);
    }

    private void pruneHorizontalMetrics(TTHorizontalMetrics metrics, List<Integer> gids) {
        int[] advanceWidths = new int[gids.size()];
        short[] leftSideBearings = new short[gids.size()];
        int newGid = 0;
        for (int oldGid : gids) {
            advanceWidths[newGid] = metrics.getAdvanceWidth(oldGid);
            leftSideBearings[newGid] = metrics.getLeftSideBearing(oldGid);
            ++newGid;
        }
        metrics.setMetrics(advanceWidths, leftSideBearings);
    }

    private TTNaming pruneNames(TTNaming oldNaming) {
        TTNaming newNaming = new TTNaming();
        for (int nameId = 0; nameId <= 7; ++nameId) {
            TTNameRecord nameRecord = oldNaming.getNameRecord(nameId);
            if (nameRecord == null) continue;
            newNaming.putNameRecord(nameRecord);
        }
        return newNaming;
    }

    public static class Builder {
        private TTFont font;
        private Collection<Integer> cids;
        private Collection<Integer> gids;
        private Collection<String> tagsToRetain = List.of();
        private Collection<TTSerializable> serializables = new ArrayList<TTSerializable>();
        private TTCMap cmap;

        public Builder(TTFont font) {
            this.font = font;
        }

        public Builder withPreferredCMap() throws TTException {
            TTCMap preferredCMap;
            TTCharacterToGlyphIndexMapping table = this.font.get(TTCharacterToGlyphIndexMapping.class);
            if (table != null && (preferredCMap = table.getPreferredCMap()) != null) {
                return this.withCMap(preferredCMap);
            }
            throw new TTException("No preferred CMap found");
        }

        public Builder withCMap(TTCMap cmap) {
            this.cmap = cmap;
            return this;
        }

        public Builder withCids(Collection<Integer> cids) {
            this.cids = cids;
            return this;
        }

        public Builder withGids(Collection<Integer> gids) {
            this.gids = gids;
            return this;
        }

        public Builder retainTables(Collection<String> tags) {
            this.tagsToRetain = tags;
            return this;
        }

        public Builder put(TTSerializable serializable) {
            this.serializables.add(serializable);
            return this;
        }

        public TTFontSubsetter build() throws TTException {
            Collection<Integer> finalGids = this.gids;
            if (finalGids == null) {
                if (this.cids == null || this.cmap == null) {
                    throw new TTException("No GIDs specified; missing CIDs or CMap to compute them");
                }
                finalGids = Stream.concat(Stream.of(Integer.valueOf(0)), this.cids.stream()).map(this.cmap::getGlyphId).distinct().sorted().toList();
            }
            ArrayList<TTSerializable> finalSerializables = new ArrayList<TTSerializable>(this.serializables);
            if (this.cmap != null) {
                finalSerializables.add(this.pruneCidToGidMapping(this.cmap, this.cids, finalGids));
            }
            return new TTFontSubsetter(this.font, finalGids, this.tagsToRetain, finalSerializables);
        }

        private TTCharacterToGlyphIndexMapping pruneCidToGidMapping(TTCMap oldCMap, Collection<Integer> cids, Collection<Integer> gids) {
            Map<Integer, Integer> oldToNewGid = TTFontSubsetter.enumerate(gids);
            HashMap<Integer, Integer> cidToGid = new HashMap<Integer, Integer>(cids.size());
            for (int cid : cids) {
                int oldGid = oldCMap.getGlyphId(cid);
                int newGid = oldToNewGid.get(oldGid);
                if (newGid == 0) continue;
                cidToGid.put(cid, newGid);
            }
            TTCMap newCMap = new TTCMap(oldCMap.getPlatformId(), oldCMap.getEncodingId(), cidToGid);
            TTCharacterToGlyphIndexMapping mapping = new TTCharacterToGlyphIndexMapping();
            mapping.putCMap(newCMap);
            return mapping;
        }
    }
}

