/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTOutput;
import de.intarsys.cwt.font.truetype.TTSerializable;
import java.io.IOException;

public class TTHorizontalMetrics
implements TTSerializable {
    private int[] advanceWidths;
    private short[] leftSideBearings;

    @Override
    public String getTag() {
        return "hmtx";
    }

    @Override
    public void read(TTFont font, TTInput input) throws IOException, TTException {
        int numberOfGlyphs = font.getMaximumProfile().getNumGlyphs();
        int numberOfHMetrics = font.getHorizontalHeader().getNumberOfHMetrics();
        this.advanceWidths = new int[numberOfGlyphs];
        this.leftSideBearings = new short[numberOfGlyphs];
        for (int i = 0; i < numberOfHMetrics; ++i) {
            this.advanceWidths[i] = input.readUInt16();
            this.leftSideBearings[i] = input.readInt16();
        }
        int lastAdvanceWidth = numberOfHMetrics > 0 ? this.advanceWidths[numberOfHMetrics - 1] : 0;
        for (int i = numberOfHMetrics; i < numberOfGlyphs; ++i) {
            this.advanceWidths[i] = lastAdvanceWidth;
            this.leftSideBearings[i] = input.readInt16();
        }
    }

    @Override
    public void write(TTOutput output) throws IOException {
        int i;
        int numberOfGlyphs = this.advanceWidths.length;
        int numberOfHMetrics = this.getNumberOfHMetrics();
        for (i = 0; i < numberOfHMetrics; ++i) {
            output.writeUInt16(this.advanceWidths[i]);
            output.writeInt16(this.leftSideBearings[i]);
        }
        for (i = numberOfHMetrics; i < numberOfGlyphs; ++i) {
            output.writeInt16(this.leftSideBearings[i]);
        }
    }

    public int getAdvanceWidth(int gid) {
        return this.advanceWidths[gid];
    }

    public int[] getAdvanceWidths() {
        return this.advanceWidths;
    }

    public short getLeftSideBearing(int gid) {
        return this.leftSideBearings[gid];
    }

    public short[] getLeftSideBearings() {
        return this.leftSideBearings;
    }

    public void setMetrics(int[] advanceWidths, short[] leftSideBearings) {
        if (advanceWidths.length != leftSideBearings.length) {
            throw new IllegalArgumentException("advanceWidths.length != leftSideBearings.length");
        }
        this.advanceWidths = advanceWidths;
        this.leftSideBearings = leftSideBearings;
    }

    public int getNumberOfHMetrics() {
        if (this.advanceWidths == null || this.advanceWidths.length == 0) {
            return 0;
        }
        int lastAdvanceWidth = this.advanceWidths[this.advanceWidths.length - 1];
        for (int i = this.advanceWidths.length - 2; i >= 0; --i) {
            if (this.advanceWidths[i] == lastAdvanceWidth) continue;
            return i + 2;
        }
        return 1;
    }
}

