/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTOutput;
import de.intarsys.cwt.font.truetype.TTSerializable;
import java.io.IOException;

public class TTIndexToLocation
implements TTSerializable {
    private boolean shortFormat = true;
    private long[] offsets;

    @Override
    public String getTag() {
        return "loca";
    }

    @Override
    public void read(TTFont font, TTInput input) throws IOException, TTException {
        this.shortFormat = font.getFontHeader().getIndexToLocFormat() == 0;
        int numGlyphs = font.getMaximumProfile().getNumGlyphs();
        if (this.shortFormat) {
            this.offsets = new long[numGlyphs + 1];
            for (int i = 0; i <= numGlyphs; ++i) {
                this.offsets[i] = input.readUInt16() * 2;
            }
        } else {
            this.offsets = new long[numGlyphs + 1];
            for (int i = 0; i <= numGlyphs; ++i) {
                this.offsets[i] = input.readUInt32();
            }
        }
    }

    @Override
    public void write(TTOutput output) throws IOException {
        if (this.shortFormat) {
            for (long offset : this.offsets) {
                output.writeUInt16((int)(offset / 2L));
            }
        } else {
            for (long offset : this.offsets) {
                output.writeUInt32(offset);
            }
        }
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public void setOffsets(long[] offsets) {
        this.offsets = offsets;
    }

    public boolean isShortFormat() {
        return this.shortFormat;
    }

    public void setShortFormat(boolean shortFormat) {
        this.shortFormat = shortFormat;
    }
}

