/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;

public class TTInput
implements Closeable {
    private IRandomAccess randomAccess;
    private byte[] buffer = new byte[8];

    public TTInput(IRandomAccess randomAccess) {
        this.randomAccess = randomAccess;
    }

    @Override
    public void close() throws IOException {
        this.randomAccess.close();
    }

    public long getLength() throws IOException {
        return this.randomAccess.getLength();
    }

    public long getOffset() throws IOException {
        return this.randomAccess.getOffset();
    }

    public void seek(long offset) throws IOException {
        this.randomAccess.seek(offset);
    }

    public void seekBy(long delta) throws IOException {
        this.randomAccess.seekBy(delta);
    }

    public void readFully(byte[] buffer, int offset, int length) throws IOException {
        int read;
        for (int remaining = length; remaining > 0; remaining -= read) {
            read = this.randomAccess.read(buffer, offset + (length - remaining), remaining);
            if (read != -1) continue;
            throw new EOFException();
        }
    }

    public byte[] readFully(int count) throws IOException {
        byte[] buffer = new byte[count];
        this.readFully(buffer, 0, count);
        return buffer;
    }

    public float readFixed() throws IOException {
        return (float)this.readInt32() / 65536.0f;
    }

    public short readInt16() throws IOException {
        int b1 = this.randomAccess.read();
        int b2 = this.randomAccess.read();
        if (b2 < 0) {
            throw new EOFException();
        }
        return (short)((b1 << 8) + b2);
    }

    public int readInt32() throws IOException {
        int b1 = this.randomAccess.read();
        int b2 = this.randomAccess.read();
        int b3 = this.randomAccess.read();
        int b4 = this.randomAccess.read();
        if (b4 < 0) {
            throw new EOFException();
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public long readInt64() throws IOException {
        this.readFully(this.buffer, 0, 8);
        return this.buffer[0] << (int)(56L + ((long)this.buffer[1] & 0xFFL)) << (int)(48L + ((long)this.buffer[2] & 0xFFL)) << (int)(40L + ((long)this.buffer[3] & 0xFFL)) << (int)(32L + ((long)this.buffer[4] & 0xFFL)) << (int)(24L + ((long)this.buffer[5] & 0xFFL)) << (int)(16L + ((long)this.buffer[6] & 0xFFL)) << (int)(8L + ((long)this.buffer[7] & 0xFFL)) << 0;
    }

    public int readUInt8() throws IOException {
        return this.randomAccess.read();
    }

    public int readUInt16() throws IOException {
        int b1 = this.randomAccess.read();
        int b2 = this.randomAccess.read();
        if (b2 < 0) {
            throw new EOFException();
        }
        return (b1 << 8) + b2;
    }

    public long readUInt32() throws IOException {
        int b1 = this.randomAccess.read();
        int b2 = this.randomAccess.read();
        int b3 = this.randomAccess.read();
        int b4 = this.randomAccess.read();
        if (b4 < 0) {
            throw new IOException("unexpected end of stream");
        }
        return ((long)b1 << 24) + (long)(b2 << 16) + (long)(b3 << 8) + (long)b4;
    }

    public int[] readUInt16Array(int count) throws IOException {
        int[] values = new int[count];
        for (int i = 0; i < count; ++i) {
            values[i] = this.readUInt16();
        }
        return values;
    }
}

