/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTOutput;
import de.intarsys.cwt.font.truetype.TTSerializable;
import java.io.IOException;

public class TTMetrics
implements TTSerializable {
    public static final int FS_TYPE_EXCLUSIVE_MASK = 15;
    public static final int FS_TYPE_RESTRICTED = 2;
    public static final int FS_TYPE_PREVIEW_AND_PRINT = 4;
    public static final int FS_TYPE_EDITABLE = 8;
    public static final int FS_TYPE_NO_SUBSETTING = 256;
    public static final int FS_TYPE_BITMAP_EDITING_ONLY = 512;
    private int version;
    private short xAvgCharWidth;
    private int usWeightClass;
    private int usWidthClass;
    private int fsType;
    private short ySubscriptXSize;
    private short ySubscriptYSize;
    private short ySubscriptXOffset;
    private short ySubscriptYOffset;
    private short ySuperscriptXSize;
    private short ySuperscriptYSize;
    private short ySuperscriptXOffset;
    private short ySuperscriptYOffset;
    private short yStrikeoutSize;
    private short yStrikeoutPosition;
    private short sFamilyClass;
    private byte[] panose = new byte[10];
    private long ulUnicodeRange1;
    private long ulUnicodeRange2;
    private long ulUnicodeRange3;
    private long ulUnicodeRange4;
    private byte[] achVendID = new byte[4];
    private int fsSelection;
    private int usFirstCharIndex;
    private int usLastCharIndex;
    private short sTypoAscender;
    private short sTypoDescender;
    private short sTypoLineGap;
    private int usWinAscent;
    private int usWinDescent;
    private long ulCodePageRange1;
    private long ulCodePageRange2;
    private short sxHeight;
    private short sCapHeight;
    private int usDefaultChar;
    private int usBreakChar;
    private int usMaxContext;
    private int usLowerOpticalPointSize;
    private int usUpperOpticalPointSize;

    @Override
    public String getTag() {
        return "OS/2";
    }

    @Override
    public void read(TTFont font, TTInput input) throws IOException {
        this.version = input.readUInt16();
        this.xAvgCharWidth = input.readInt16();
        this.usWeightClass = input.readUInt16();
        this.usWidthClass = input.readUInt16();
        this.fsType = input.readUInt16();
        this.ySubscriptXSize = input.readInt16();
        this.ySubscriptYSize = input.readInt16();
        this.ySubscriptXOffset = input.readInt16();
        this.ySubscriptYOffset = input.readInt16();
        this.ySuperscriptXSize = input.readInt16();
        this.ySuperscriptYSize = input.readInt16();
        this.ySuperscriptXOffset = input.readInt16();
        this.ySuperscriptYOffset = input.readInt16();
        this.yStrikeoutSize = input.readInt16();
        this.yStrikeoutPosition = input.readInt16();
        this.sFamilyClass = input.readInt16();
        this.panose = input.readFully(10);
        this.ulUnicodeRange1 = input.readUInt32();
        this.ulUnicodeRange2 = input.readUInt32();
        this.ulUnicodeRange3 = input.readUInt32();
        this.ulUnicodeRange4 = input.readUInt32();
        this.achVendID = input.readFully(4);
        this.fsSelection = input.readUInt16();
        this.usFirstCharIndex = input.readUInt16();
        this.usLastCharIndex = input.readUInt16();
        this.sTypoAscender = input.readInt16();
        this.sTypoDescender = input.readInt16();
        this.sTypoLineGap = input.readInt16();
        this.usWinAscent = input.readUInt16();
        this.usWinDescent = input.readUInt16();
        if (this.version >= 1) {
            this.ulCodePageRange1 = input.readUInt32();
            this.ulCodePageRange2 = input.readUInt32();
        }
        if (this.version >= 2) {
            this.sxHeight = input.readInt16();
            this.sCapHeight = input.readInt16();
            this.usDefaultChar = input.readUInt16();
            this.usBreakChar = input.readUInt16();
            this.usMaxContext = input.readUInt16();
        }
        if (this.version >= 5) {
            this.usLowerOpticalPointSize = input.readUInt16();
            this.usUpperOpticalPointSize = input.readUInt16();
        }
    }

    @Override
    public void write(TTOutput output) throws IOException {
        output.writeUInt16(this.version);
        output.writeInt16(this.xAvgCharWidth);
        output.writeUInt16(this.usWeightClass);
        output.writeUInt16(this.usWidthClass);
        output.writeUInt16(this.fsType);
        output.writeInt16(this.ySubscriptXSize);
        output.writeInt16(this.ySubscriptYSize);
        output.writeInt16(this.ySubscriptXOffset);
        output.writeInt16(this.ySubscriptYOffset);
        output.writeInt16(this.ySuperscriptXSize);
        output.writeInt16(this.ySuperscriptYSize);
        output.writeInt16(this.ySuperscriptXOffset);
        output.writeInt16(this.ySuperscriptYOffset);
        output.writeInt16(this.yStrikeoutSize);
        output.writeInt16(this.yStrikeoutPosition);
        output.writeInt16(this.sFamilyClass);
        output.write(this.panose);
        output.writeUInt32(this.ulUnicodeRange1);
        output.writeUInt32(this.ulUnicodeRange2);
        output.writeUInt32(this.ulUnicodeRange3);
        output.writeUInt32(this.ulUnicodeRange4);
        output.write(this.achVendID);
        output.writeUInt16(this.fsSelection);
        output.writeUInt16(this.usFirstCharIndex);
        output.writeUInt16(this.usLastCharIndex);
        output.writeInt16(this.sTypoAscender);
        output.writeInt16(this.sTypoDescender);
        output.writeInt16(this.sTypoLineGap);
        output.writeUInt16(this.usWinAscent);
        output.writeUInt16(this.usWinDescent);
        if (this.version >= 1) {
            output.writeUInt32(this.ulCodePageRange1);
            output.writeUInt32(this.ulCodePageRange2);
        }
        if (this.version >= 2) {
            output.writeInt16(this.sxHeight);
            output.writeInt16(this.sCapHeight);
            output.writeUInt16(this.usDefaultChar);
            output.writeUInt16(this.usBreakChar);
            output.writeUInt16(this.usMaxContext);
        }
        if (this.version >= 5) {
            output.writeUInt16(this.usLowerOpticalPointSize);
            output.writeUInt16(this.usUpperOpticalPointSize);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public short getXAvgCharWidth() {
        return this.xAvgCharWidth;
    }

    public void setXAvgCharWidth(short xAvgCharWidth) {
        this.xAvgCharWidth = xAvgCharWidth;
    }

    public int getUsWeightClass() {
        return this.usWeightClass;
    }

    public void setUsWeightClass(int usWeightClass) {
        this.usWeightClass = usWeightClass;
    }

    public int getUsWidthClass() {
        return this.usWidthClass;
    }

    public void setUsWidthClass(int usWidthClass) {
        this.usWidthClass = usWidthClass;
    }

    public int getFsType() {
        return this.fsType;
    }

    public void setFsType(int fsType) {
        this.fsType = fsType;
    }

    public short getYSubscriptXSize() {
        return this.ySubscriptXSize;
    }

    public void setYSubscriptXSize(short ySubscriptXSize) {
        this.ySubscriptXSize = ySubscriptXSize;
    }

    public short getYSubscriptYSize() {
        return this.ySubscriptYSize;
    }

    public void setYSubscriptYSize(short ySubscriptYSize) {
        this.ySubscriptYSize = ySubscriptYSize;
    }

    public short getYSubscriptXOffset() {
        return this.ySubscriptXOffset;
    }

    public void setYSubscriptXOffset(short ySubscriptXOffset) {
        this.ySubscriptXOffset = ySubscriptXOffset;
    }

    public short getYSubscriptYOffset() {
        return this.ySubscriptYOffset;
    }

    public void setYSubscriptYOffset(short ySubscriptYOffset) {
        this.ySubscriptYOffset = ySubscriptYOffset;
    }

    public short getYSuperscriptXSize() {
        return this.ySuperscriptXSize;
    }

    public void setYSuperscriptXSize(short ySuperscriptXSize) {
        this.ySuperscriptXSize = ySuperscriptXSize;
    }

    public short getYSuperscriptYSize() {
        return this.ySuperscriptYSize;
    }

    public void setYSuperscriptYSize(short ySuperscriptYSize) {
        this.ySuperscriptYSize = ySuperscriptYSize;
    }

    public short getYSuperscriptXOffset() {
        return this.ySuperscriptXOffset;
    }

    public void setYSuperscriptXOffset(short ySuperscriptXOffset) {
        this.ySuperscriptXOffset = ySuperscriptXOffset;
    }

    public short getYSuperscriptYOffset() {
        return this.ySuperscriptYOffset;
    }

    public void setYSuperscriptYOffset(short ySuperscriptYOffset) {
        this.ySuperscriptYOffset = ySuperscriptYOffset;
    }

    public short getYStrikeoutSize() {
        return this.yStrikeoutSize;
    }

    public void setYStrikeoutSize(short yStrikeoutSize) {
        this.yStrikeoutSize = yStrikeoutSize;
    }

    public short getYStrikeoutPosition() {
        return this.yStrikeoutPosition;
    }

    public void setYStrikeoutPosition(short yStrikeoutPosition) {
        this.yStrikeoutPosition = yStrikeoutPosition;
    }

    public short getSFamilyClass() {
        return this.sFamilyClass;
    }

    public void setSFamilyClass(short sFamilyClass) {
        this.sFamilyClass = sFamilyClass;
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public void setPanose(byte[] panose) {
        if (panose == null || panose.length != 10) {
            throw new IllegalArgumentException("panose must be a 10-byte array");
        }
        this.panose = panose;
    }

    public long getUlUnicodeRange1() {
        return this.ulUnicodeRange1;
    }

    public void setUlUnicodeRange1(long ulUnicodeRange1) {
        this.ulUnicodeRange1 = ulUnicodeRange1;
    }

    public long getUlUnicodeRange2() {
        return this.ulUnicodeRange2;
    }

    public void setUlUnicodeRange2(long ulUnicodeRange2) {
        this.ulUnicodeRange2 = ulUnicodeRange2;
    }

    public long getUlUnicodeRange3() {
        return this.ulUnicodeRange3;
    }

    public void setUlUnicodeRange3(long ulUnicodeRange3) {
        this.ulUnicodeRange3 = ulUnicodeRange3;
    }

    public long getUlUnicodeRange4() {
        return this.ulUnicodeRange4;
    }

    public void setUlUnicodeRange4(long ulUnicodeRange4) {
        this.ulUnicodeRange4 = ulUnicodeRange4;
    }

    public byte[] getAchVendID() {
        return this.achVendID;
    }

    public void setAchVendID(byte[] achVendID) {
        if (achVendID == null || achVendID.length != 4) {
            throw new IllegalArgumentException("achVendID must be a 4-byte array");
        }
        this.achVendID = achVendID;
    }

    public int getFsSelection() {
        return this.fsSelection;
    }

    public void setFsSelection(int fsSelection) {
        this.fsSelection = fsSelection;
    }

    public int getUsFirstCharIndex() {
        return this.usFirstCharIndex;
    }

    public void setUsFirstCharIndex(int usFirstCharIndex) {
        this.usFirstCharIndex = usFirstCharIndex;
    }

    public int getUsLastCharIndex() {
        return this.usLastCharIndex;
    }

    public void setUsLastCharIndex(int usLastCharIndex) {
        this.usLastCharIndex = usLastCharIndex;
    }

    public short getsTypoAscender() {
        return this.sTypoAscender;
    }

    public void setsTypoAscender(short sTypoAscender) {
        this.sTypoAscender = sTypoAscender;
    }

    public short getsTypoDescender() {
        return this.sTypoDescender;
    }

    public void setsTypoDescender(short sTypoDescender) {
        this.sTypoDescender = sTypoDescender;
    }

    public short getsTypoLineGap() {
        return this.sTypoLineGap;
    }

    public void setsTypoLineGap(short sTypoLineGap) {
        this.sTypoLineGap = sTypoLineGap;
    }

    public int getUsWinAscent() {
        return this.usWinAscent;
    }

    public void setUsWinAscent(int usWinAscent) {
        this.usWinAscent = usWinAscent;
    }

    public int getUsWinDescent() {
        return this.usWinDescent;
    }

    public void setUsWinDescent(int usWinDescent) {
        this.usWinDescent = usWinDescent;
    }

    public long getUlCodePageRange1() {
        return this.ulCodePageRange1;
    }

    public void setUlCodePageRange1(long ulCodePageRange1) {
        this.ulCodePageRange1 = ulCodePageRange1;
    }

    public long getUlCodePageRange2() {
        return this.ulCodePageRange2;
    }

    public void setUlCodePageRange2(long ulCodePageRange2) {
        this.ulCodePageRange2 = ulCodePageRange2;
    }

    public short getSxHeight() {
        return this.sxHeight;
    }

    public void setSxHeight(short sxHeight) {
        this.sxHeight = sxHeight;
    }

    public short getsCapHeight() {
        return this.sCapHeight;
    }

    public void setsCapHeight(short sCapHeight) {
        this.sCapHeight = sCapHeight;
    }

    public int getUsDefaultChar() {
        return this.usDefaultChar;
    }

    public void setUsDefaultChar(int usDefaultChar) {
        this.usDefaultChar = usDefaultChar;
    }

    public int getUsBreakChar() {
        return this.usBreakChar;
    }

    public void setUsBreakChar(int usBreakChar) {
        this.usBreakChar = usBreakChar;
    }

    public int getUsMaxContext() {
        return this.usMaxContext;
    }

    public void setUsMaxContext(int usMaxContext) {
        this.usMaxContext = usMaxContext;
    }

    public int getUsLowerOpticalPointSize() {
        return this.usLowerOpticalPointSize;
    }

    public void setUsLowerOpticalPointSize(int usLowerOpticalPointSize) {
        this.usLowerOpticalPointSize = usLowerOpticalPointSize;
    }

    public int getUsUpperOpticalPointSize() {
        return this.usUpperOpticalPointSize;
    }

    public void setUsUpperOpticalPointSize(int usUpperOpticalPointSize) {
        this.usUpperOpticalPointSize = usUpperOpticalPointSize;
    }

    public boolean isRestricted() {
        return (this.fsType & 0xF) == 2;
    }

    public boolean isSubsettingPermitted() {
        return !this.isRestricted() && (this.fsType & 0x100) == 0;
    }

    public boolean isEmbeddingPermitted() {
        return !this.isRestricted() && (this.fsType & 0x200) == 0;
    }
}

