/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTNameRecord;
import de.intarsys.cwt.font.truetype.TTOutput;
import de.intarsys.cwt.font.truetype.TTSerializable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TTNaming
implements TTSerializable {
    public static final int NAME_COPYRIGHT_NOTICE = 0;
    public static final int NAME_FONT_FAMILY_NAME = 1;
    public static final int NAME_FONT_SUBFAMILY_NAME = 2;
    public static final int NAME_UNIQUE_FONT_IDENTIFIER = 3;
    public static final int NAME_FULL_FONT_NAME = 4;
    public static final int NAME_VERSION_STRING = 5;
    public static final int NAME_POSTSCRIPT_NAME = 6;
    public static final int NAME_TRADEMARK = 7;
    public static final int NAME_MANUFACTURER_NAME = 8;
    public static final int NAME_LICENSE_DESCRIPTION = 13;
    public static final int NAME_LICENSE_INFO_URL = 14;
    private static final int[] UNICODE_ENCODINGS = new int[]{0, 1, 3, 4};
    private static final int[] WINDOWS_ENCODINGS = new int[]{1, 10};
    private static final int[] MACINTOSH_ENCODINGS = new int[]{0};
    private static final Comparator<TTNameRecord> SERIALIZED_ORDER = Comparator.comparing(TTNameRecord::getPlatformId).thenComparing(TTNameRecord::getEncodingId).thenComparing(TTNameRecord::getLanguageId).thenComparing(TTNameRecord::getNameId);
    private Map<Key, TTNameRecord> records = new HashMap<Key, TTNameRecord>();

    @Override
    public String getTag() {
        return "name";
    }

    @Override
    public void read(TTFont font, TTInput input) throws IOException {
        input.readUInt16();
        int count = input.readUInt16();
        int storageOffset = input.readUInt16();
        for (int i = 0; i < count; ++i) {
            int platformId = input.readUInt16();
            int encodingId = input.readUInt16();
            int languageId = input.readUInt16();
            int nameId = input.readUInt16();
            int nameLength = input.readUInt16();
            int nameOffset = input.readUInt16();
            long mark = input.getOffset();
            input.seek(storageOffset + nameOffset);
            byte[] name = input.readFully(nameLength);
            input.seek(mark);
            Charset charset = this.getCharset(platformId, encodingId);
            this.putName(platformId, encodingId, languageId, nameId, new String(name, charset));
        }
    }

    @Override
    public void write(TTOutput output) throws IOException {
        output.writeUInt16(0);
        output.writeUInt16(this.records.size());
        output.writeUInt16(6 + this.records.size() * 6 * 2);
        ArrayList<TTNameRecord> sortedRecords = new ArrayList<TTNameRecord>(this.records.values());
        sortedRecords.sort(SERIALIZED_ORDER);
        ArrayList<byte[]> values = new ArrayList<byte[]>(this.records.size());
        int offset = 0;
        for (TTNameRecord record : sortedRecords) {
            Charset charset = this.getCharset(record.getPlatformId(), record.getEncodingId());
            byte[] value = record.getValue().getBytes(charset);
            output.writeUInt16(record.getPlatformId());
            output.writeUInt16(record.getEncodingId());
            output.writeUInt16(record.getLanguageId());
            output.writeUInt16(record.getNameId());
            output.writeUInt16(value.length);
            output.writeUInt16(offset);
            offset += value.length;
            values.add(value);
        }
        for (byte[] value : values) {
            output.write(value);
        }
    }

    private Charset getCharset(int platformId, int encodingId) {
        if (platformId == 0) {
            return StandardCharsets.UTF_16;
        }
        if (platformId == 3 && (encodingId == 0 || encodingId == 1)) {
            return StandardCharsets.UTF_16BE;
        }
        if (platformId == 2) {
            if (encodingId == 0) {
                return StandardCharsets.US_ASCII;
            }
            if (encodingId == 1) {
                return StandardCharsets.UTF_16;
            }
            if (encodingId == 2) {
                return StandardCharsets.ISO_8859_1;
            }
        }
        return StandardCharsets.ISO_8859_1;
    }

    public Collection<TTNameRecord> getNameRecords() {
        return new ArrayList<TTNameRecord>(this.records.values());
    }

    public TTNameRecord getNameRecord(int platformId, int encodingId, int languageId, int nameId) {
        return this.records.get(new Key(platformId, encodingId, languageId, nameId));
    }

    public TTNameRecord getNameRecord(int nameId) {
        TTNameRecord record;
        for (int encodingId : WINDOWS_ENCODINGS) {
            record = this.getNameRecord(3, encodingId, 1033, nameId);
            if (record == null) continue;
            return record;
        }
        for (int encodingId : UNICODE_ENCODINGS) {
            record = this.getNameRecord(0, encodingId, 0, nameId);
            if (record == null) continue;
            return record;
        }
        for (int encodingId : MACINTOSH_ENCODINGS) {
            record = this.getNameRecord(1, encodingId, 0, nameId);
            if (record == null) continue;
            return record;
        }
        return this.records.values().stream().filter(r -> r.getNameId() == nameId).findAny().orElse(null);
    }

    public TTNameRecord removeNameRecord(int platformId, int encodingId, int languageId, int nameId) {
        return this.records.remove(new Key(platformId, encodingId, languageId, nameId));
    }

    public void removeNameRecord(TTNameRecord nameRecord) {
        this.records.remove(new Key(nameRecord));
    }

    public void putNameRecord(TTNameRecord nameRecord) {
        this.records.put(new Key(nameRecord), nameRecord);
    }

    public void putName(int platformId, int encodingId, int languageId, int nameId, String value) {
        this.putNameRecord(new TTNameRecord(platformId, encodingId, languageId, nameId, value));
    }

    public String getName(int nameId) {
        TTNameRecord record = this.getNameRecord(nameId);
        return record == null ? null : record.getValue();
    }

    public String getName(int platformId, int encodingId, int languageId, int nameId) {
        TTNameRecord nameRecord = this.getNameRecord(platformId, encodingId, languageId, nameId);
        return nameRecord == null ? null : nameRecord.getValue();
    }

    private static class Key {
        private final int platform;
        private final int encoding;
        private final int language;
        private final int name;

        public Key(TTNameRecord record) {
            this(record.getPlatformId(), record.getEncodingId(), record.getLanguageId(), record.getNameId());
        }

        public Key(int platform, int encoding, int language, int name) {
            this.platform = platform;
            this.encoding = encoding;
            this.language = language;
            this.name = name;
        }

        public int hashCode() {
            return Objects.hash(this.platform, this.encoding, this.language, this.name);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            Key otherKey = (Key)other;
            return otherKey.platform == this.platform && otherKey.encoding == this.encoding && otherKey.language == this.language && otherKey.name == this.name;
        }

        public String toString() {
            return String.format("(platform=%d, encoding=%d, language=%d, name=%d)", this.platform, this.encoding, this.language, this.name);
        }
    }
}

