/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

public class TTOutput
implements Closeable {
    private OutputStream outputStream;
    private byte[] buffer = new byte[8];

    public TTOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.outputStream.write(buffer, offset, length);
    }

    public void writeFixed(float value) throws IOException {
        this.writeInt32((int)(value * 65536.0f));
    }

    public void writeInt8(int value) throws IOException {
        this.outputStream.write(value);
    }

    public void writeInt16(int value) throws IOException {
        this.buffer[0] = (byte)(value >> 8);
        this.buffer[1] = (byte)value;
        this.write(this.buffer, 0, 2);
    }

    public void writeInt32(int value) throws IOException {
        this.buffer[0] = (byte)(value >> 24);
        this.buffer[1] = (byte)(value >> 16);
        this.buffer[2] = (byte)(value >> 8);
        this.buffer[3] = (byte)value;
        this.write(this.buffer, 0, 4);
    }

    public void writeInt64(long value) throws IOException {
        this.buffer[0] = (byte)(value >> 56);
        this.buffer[1] = (byte)(value >> 48);
        this.buffer[2] = (byte)(value >> 40);
        this.buffer[3] = (byte)(value >> 32);
        this.buffer[4] = (byte)(value >> 24);
        this.buffer[5] = (byte)(value >> 16);
        this.buffer[6] = (byte)(value >> 8);
        this.buffer[7] = (byte)value;
        this.write(this.buffer, 0, 8);
    }

    public void writeUInt8(int value) throws IOException {
        this.writeInt8(value);
    }

    public void writeUInt16(int value) throws IOException {
        this.writeInt16(value);
    }

    public void writeUInt32(long value) throws IOException {
        this.writeInt32((int)value);
    }
}

