/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTInput;
import de.intarsys.cwt.font.truetype.TTOutput;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.randomaccess.RandomAccessViewport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TTTable {
    public static final String TAG_CMAP = "cmap";
    public static final String TAG_CVT = "cvt ";
    public static final String TAG_FGPM = "fpgm";
    public static final String TAG_GLYF = "glyf";
    public static final String TAG_HEAD = "head";
    public static final String TAG_HHEA = "hhea";
    public static final String TAG_HMTX = "hmtx";
    public static final String TAG_LOCA = "loca";
    public static final String TAG_MAXP = "maxp";
    public static final String TAG_NAME = "name";
    public static final String TAG_OS2 = "OS/2";
    public static final String TAG_POST = "post";
    public static final String TAG_PREP = "prep";
    private String tag;
    private TTFont font;
    private byte[] bytes;
    private long offset;
    private long length;
    private int checksum;

    public TTTable(String tag) {
        this.tag = tag;
        this.bytes = new byte[0];
    }

    public TTTable(TTFont font, String tag, long offset, long length, int checksum) {
        this.font = font;
        this.tag = tag;
        this.offset = offset;
        this.length = length;
        this.checksum = checksum;
    }

    public TTFont getFont() {
        return this.font;
    }

    public void setFont(TTFont font) {
        this.font = font;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int checksum) {
        this.checksum = checksum;
    }

    public String getTag() {
        return this.tag;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        if (this.bytes != null) {
            return new RandomAccessByteArray(this.bytes);
        }
        IRandomAccess random = this.getFont().getLocator().getRandomAccess();
        RandomAccessViewport viewport = new RandomAccessViewport(random, this.getOffset(), this.getLength());
        viewport.seek(0L);
        return viewport;
    }

    public TTInput getInput() throws IOException {
        return new TTInput(this.getRandomAccess());
    }

    public TTOutput getOutput() {
        final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        return new TTOutput(bytes){

            @Override
            public void close() throws IOException {
                TTTable.this.setBytes(bytes.toByteArray());
            }
        };
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
        this.offset = 0L;
        this.length = bytes.length;
        this.checksum = 0;
    }

    public String toString() {
        return this.tag;
    }
}

