/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.type1;

public class PFB {
    private static final int SEGMENT_HEADER_SIZE = 6;
    private static final byte SEGMENT_START = -128;
    private static final byte ASCII = 1;
    private static final byte BINARY = 2;
    private static final byte[] SEGMENTS = new byte[]{1, 2, 1};
    private byte[] data;
    private int[] lengths;

    public static PFB from(byte[] data) {
        int[] lengths = new int[SEGMENTS.length];
        int position = 0;
        for (int index = 0; index < SEGMENTS.length; ++index) {
            if (position + 6 >= data.length) {
                throw new IllegalArgumentException("unexpected end of data in segment " + index);
            }
            if (data[position] != -128) {
                throw new IllegalArgumentException("expected segment start (0x80) at " + position);
            }
            if (data[++position] != SEGMENTS[index]) {
                throw new IllegalArgumentException(String.format("expected segment %d to be of type 0x%02x, but got 0x%02x", index, Byte.toUnsignedInt(SEGMENTS[index]), Byte.toUnsignedInt(data[position])));
            }
            int n = ++position;
            int n2 = ++position;
            int n3 = ++position;
            int n4 = ++position;
            ++position;
            lengths[index] = data[n] & 0xFF | (data[n2] & 0xFF) << 8 | (data[n3] & 0xFF) << 16 | (data[n4] & 0xFF) << 24;
            position += lengths[index];
        }
        return new PFB(data, lengths);
    }

    public PFB(byte[] data, int[] lengths) {
        this.data = data;
        this.lengths = lengths;
    }

    public int getLength1() {
        return this.lengths[0];
    }

    public int getLength2() {
        return this.lengths[1];
    }

    public int getLength3() {
        return this.lengths[2];
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getStrippedData() {
        byte[] strippedData = new byte[this.lengths[0] + this.lengths[1]];
        int start1 = 6;
        int length1 = this.lengths[0];
        System.arraycopy(this.data, start1, strippedData, 0, length1);
        int start2 = start1 + length1 + 6;
        int length2 = this.lengths[1];
        System.arraycopy(this.data, start2, strippedData, length1, length2);
        return strippedData;
    }
}

