/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.common;

import de.intarsys.pdf.app.appearance.common.CommonWidgetAppearanceCreator;
import de.intarsys.pdf.app.colorspace.ColorSpaceImporter;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDXObject;
import java.awt.geom.Rectangle2D;

public abstract class AbstractLayeredAppearanceCreator
extends CommonWidgetAppearanceCreator {
    private boolean embedFonts = false;
    private int minHeight = 0;

    protected AbstractLayeredAppearanceCreator() {
    }

    protected void adjustSize(Rectangle2D bboxSource, CDSRectangle bboxTarget) {
        bboxTarget.resizeTo((float)bboxSource.getWidth(), (float)bboxSource.getHeight());
    }

    protected void appearanceAddLayer(PDForm parentForm, PDForm childForm, String name) {
        if (childForm != null) {
            CSCreator creator = CSCreator.createFromProvider((IContentStreamProvider)parentForm);
            creator.saveState();
            float dx = (parentForm.getBoundingBox().getWidth() - childForm.getBoundingBox().getWidth()) / 2.0f;
            float dy = (parentForm.getBoundingBox().getHeight() - childForm.getBoundingBox().getHeight()) / 2.0f;
            creator.transform(1.0f, 0.0f, 0.0f, 1.0f, dx, dy);
            creator.doXObject(COSName.create((String)name), (PDXObject)childForm);
            creator.restoreState();
            creator.close();
        }
    }

    @Override
    public PDAppearance createAppearance(PDAnnotation annotation, PDAppearance appearance) {
        annotation.setAppearance(null);
        return super.createAppearance(annotation, null);
    }

    @Override
    protected void createAppearanceForms(PDAnnotation annot, PDAppearance appearance) {
        CDSRectangle annotRect = annot.getNormalizedRectangle();
        if (annotRect.getHeight() < (float)this.getMinHeight()) {
            float newY = annotRect.getLowerLeftY() - ((float)this.getMinHeight() - annotRect.getHeight()) / 2.0f;
            annotRect.setLowerLeftY(newY);
            annotRect.setHeight((float)this.getMinHeight());
            annot.setRectangle(annotRect);
        }
        PDForm formNormal = this.createNormalAppearance(annot, appearance);
        PDForm formFRM = this.createForm(formNormal.getBoundingBox());
        PDForm formN2 = this.createAppearanceLayerN2(annot, formNormal.getBoundingBox());
        PDForm formN0 = this.createAppearanceLayerN0(annot, formN2.getBoundingBox());
        this.adjustSize(formN2.getTransformedBBox(), formFRM.getBoundingBox());
        this.adjustSize(formFRM.getTransformedBBox(), formNormal.getBoundingBox());
        this.adjustSize(formNormal.getTransformedBBox(), annot.getRectangle());
        this.appearanceAddLayer(formNormal, formFRM, "FRM");
        this.appearanceAddLayer(formFRM, formN0, "n0");
        this.appearanceAddLayer(formFRM, formN2, "n2");
        if (this.isEmbedFonts()) {
            ColorSpaceImporter importer = new ColorSpaceImporter(annot.getDoc());
            importer.process(appearance);
        }
    }

    protected PDForm createAppearanceLayerN0(PDAnnotation annotation, CDSRectangle bbox) {
        return this.createForm(bbox);
    }

    protected PDForm createAppearanceLayerN2(PDAnnotation annotation, CDSRectangle bbox) {
        PDForm form = this.createForm(bbox);
        CSContent content = this.createAppearanceLayerN2Content(annotation, form);
        if (content.size() > 100 && !form.cosGetStream().hasFilter(Filter.CN_Filter_FlateDecode)) {
            form.cosGetStream().addFilter(Filter.CN_Filter_FlateDecode);
        }
        return form;
    }

    protected abstract CSContent createAppearanceLayerN2Content(PDAnnotation var1, PDForm var2);

    protected PDForm createForm(CDSRectangle rect) {
        PDForm formFRM = (PDForm)PDForm.META.createNew();
        formFRM.setBoundingBox(rect.copy());
        return formFRM;
    }

    public COSName getAnnotationType() {
        return null;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public boolean isEmbedFonts() {
        return this.embedFonts;
    }

    protected boolean isNoRotate() {
        return false;
    }

    public void setEmbedFonts(boolean embedFonts) {
        this.embedFonts = embedFonts;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }
}

