/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.common;

import de.intarsys.layout.CAlignment;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.pdf.app.appearance.AppearanceCreatorRegistry;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLLayouter;
import de.intarsys.pdf.layout.pad.PDLParagraphFormat;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.layout.pad.PDLTextPad;
import de.intarsys.pdf.layout.parser.PDLTextBidiParser;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Rectangle2D;
import java.io.Reader;
import java.io.StringReader;

public class AppearanceTools {
    private static final Object ATTR_INITIALIZED = new Object();

    @Deprecated
    public static Rectangle2D calcRect(PDFont font, float fontSize, String text) {
        PDLTextPad pad = AppearanceTools.createPad(font, fontSize);
        PDLTextBidiParser parser = new PDLTextBidiParser();
        parser.setPad((IPDLTextPad)pad);
        parser.setMode(1);
        try {
            StringReader reader = new StringReader(text);
            parser.parse((Reader)reader);
        }
        catch (Exception e) {
            return null;
        }
        pad.getLayoutContainer().trim();
        float width = pad.getLayoutContainer().getWidth();
        float height = pad.getLayoutContainer().getHeight();
        return new Rectangle2D.Float(0.0f, 0.0f, width, height);
    }

    protected static PDLTextPad createPad(PDFont font, float fontSize) {
        PDLTextFormat textFormat = new PDLTextFormat();
        textFormat.setFont(font);
        textFormat.setFontSize(fontSize);
        PDLParagraphFormat paragraphFormat = new PDLParagraphFormat();
        paragraphFormat.setMaxlines(-1);
        paragraphFormat.setHAlignment(CAlignment.LEFT);
        paragraphFormat.setVAlignment(CAlignment.TOP);
        PDLLayouter layouter = new PDLLayouter((Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f));
        layouter.setPrimaryBorderPolicy(CBorderPolicy.GROW);
        layouter.setSecondaryBorderPolicy(CBorderPolicy.GROW);
        return new PDLTextPad(textFormat, paragraphFormat, layouter);
    }

    @Deprecated
    public static float guessFontSize(PDLTextPad pad, String text) {
        if (StringTools.isEmpty((String)text)) {
            return 0.0f;
        }
        Rectangle2D bbox = pad.getLayouter().getBoundingBox();
        PDFont font = pad.getTextFormat().getFont();
        return AppearanceTools.guessFontSize(bbox, font, text);
    }

    @Deprecated
    public static float guessFontSize(Rectangle2D bbox, PDFont font, String text) {
        Rectangle2D rect = AppearanceTools.calcRect(font, 1.0f, text);
        if (rect == null) {
            return 8.0f;
        }
        float ratioWidth = (float)(bbox.getWidth() / rect.getWidth());
        float ratioHeight = (float)(bbox.getHeight() / rect.getHeight());
        return Math.min(ratioWidth, ratioHeight);
    }

    public static synchronized void process(PDDocument pdDoc) {
        if (pdDoc.getAttribute(ATTR_INITIALIZED) != null) {
            return;
        }
        pdDoc.setAttribute(ATTR_INITIALIZED, new Object());
        PDAcroForm form = pdDoc.getAcroForm();
        if (form == null || !form.getNeedAppearances()) {
            return;
        }
        for (PDAnnotation annotation : form.getAnnotations()) {
            IAppearanceCreator appearanceCreator = AppearanceCreatorRegistry.get().lookupAppearanceCreator(annotation.cosGetSubtype());
            if (appearanceCreator == null) continue;
            annotation.setAppearance(appearanceCreator.createAppearance(annotation, null));
        }
        form.setNeedAppearances(false);
    }

    private AppearanceTools() {
    }
}

