/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.common;

import de.intarsys.pdf.app.appearance.common.CommonAppearanceCreator;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDFormTools;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDWidgetAnnotation;

public abstract class CommonWidgetAppearanceCreator
extends CommonAppearanceCreator {
    protected PDForm createNormalAppearance(PDAnnotation annotation, PDAppearance appearance) {
        PDForm form = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.initializeBoundingBox(form, annotation);
        PDResources resources = PDFormTools.getResources((PDForm)form);
        PDResources defaultResources = null;
        if (annotation instanceof PDWidgetAnnotation) {
            defaultResources = ((PDWidgetAnnotation)annotation).getAcroFormField().getAcroForm().getDefaultResources();
        }
        if (defaultResources != null) {
            resources.cosGetDict().addIfAbsent(defaultResources.cosGetDict(), entry -> !PDResources.CN_RT_XObject.equals(entry.getKey()));
        }
        if (!form.cosGetStream().hasFilter(Filter.CN_Filter_FlateDecode)) {
            form.cosGetStream().addFilter(Filter.CN_Filter_FlateDecode);
        }
        return form;
    }

    protected void initializeBoundingBox(PDForm form, PDAnnotation annotation) {
        CDSRectangle rectangle = annotation.getRectangle().copy();
        this.initializeMatrix(form, annotation, rectangle);
        rectangle.moveTo(0.0f, 0.0f);
        form.setBoundingBox(rectangle);
    }

    protected void initializeMatrix(PDForm form, PDAnnotation annotation, CDSRectangle bbox) {
        PDPage page;
        CDSMatrix matrix = new CDSMatrix();
        if (annotation instanceof PDWidgetAnnotation) {
            ((PDWidgetAnnotation)annotation).transform(bbox, matrix);
        } else if (this.isAdjustForRotate() && (page = annotation.getPage()) != null) {
            PDAnnotationTools.transform((CDSRectangle)bbox, (CDSMatrix)matrix, (int)page.getNormalizedRotate());
        }
        if (matrix.isIdentity()) {
            if (form.getMatrix() != null) {
                form.setMatrix(null);
            }
        } else {
            form.setMatrix(matrix);
        }
    }
}

