/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.common;

import de.intarsys.pdf.app.appearance.ITextFormatProvider;
import de.intarsys.pdf.app.appearance.StaticTextFormatProvider;
import de.intarsys.pdf.app.font.SubsetFontTools;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.font.outlet.FontOutlet;
import de.intarsys.pdf.font.outlet.FontQuery;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.font.outlet.IFontQuery;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.tools.kernel.PDFColorTools;
import de.intarsys.tools.string.StringTools;

public class FontInfo {
    public static final int DEFAULT_FONT_SIZE = 10;
    private String fontFamilyName;
    private String fontName;
    private float fontSize;
    private String fontStyle;
    private float[] fontColor;
    private IFontFactory fontFactory;

    public FontInfo() {
        this(null, FontOutlet.get().lookupFontFactory(null), -1.0f, null);
    }

    public FontInfo(String fontName, IFontFactory fontFactory, float fontSize, float[] fontColor) {
        this.fontName = fontName;
        this.fontFactory = fontFactory;
        this.fontSize = fontSize;
        this.fontColor = fontColor;
    }

    public FontInfo(String fontFamilyName, String fontStyle, IFontFactory fontFactory, float fontSize, float[] fontColor) {
        this.fontFamilyName = fontFamilyName;
        this.fontStyle = fontStyle;
        this.fontFactory = fontFactory;
        this.fontSize = fontSize;
        this.fontColor = fontColor;
    }

    public float[] getFontColor() {
        return this.fontColor;
    }

    public IFontFactory getFontFactory() {
        return this.fontFactory;
    }

    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void initField(PDAcroFormField acroFormField) {
        if (this.getFontName() != null) {
            FontQuery query = new FontQuery(this.getFontName());
            try {
                PDFont font = this.fontFactory.getFont((IFontQuery)query);
                font = PDFontTools.getType0Font((PDFont)font);
                SubsetFontTools.setDedicated(font, true);
                acroFormField.setDefaultAppearanceFont(font);
            }
            catch (FontFactoryException fontFactoryException) {
                // empty catch block
            }
        }
        if (this.getFontSize() > 0.0f) {
            acroFormField.setDefaultAppearanceFontSize(this.getFontSize());
        }
        if (this.getFontColor() != null) {
            acroFormField.setDefaultAppearanceFontColor(this.getFontColor());
        }
    }

    public StaticTextFormatProvider resolve(ITextFormatProvider defaultTextFormat) {
        FontQuery query;
        StaticTextFormatProvider result = new StaticTextFormatProvider();
        PDFont tmpFont = null;
        if (!StringTools.isEmpty((String)this.getFontName())) {
            try {
                query = this.getFontFamilyName() == null ? new FontQuery(this.getFontName()) : new FontQuery(this.getFontFamilyName(), this.getFontStyle());
                tmpFont = this.getFontFactory().getFont((IFontQuery)query);
                tmpFont = PDFontTools.getType0Font((PDFont)tmpFont);
                SubsetFontTools.setDedicated(tmpFont, true);
            }
            catch (Exception query2) {
                // empty catch block
            }
        }
        if (tmpFont == null && defaultTextFormat != null) {
            tmpFont = defaultTextFormat.getFont();
        }
        if (tmpFont == null) {
            try {
                query = new FontQuery("Helvetica");
                tmpFont = this.getFontFactory().getFont((IFontQuery)query);
                tmpFont = PDFontTools.getType0Font((PDFont)tmpFont);
                SubsetFontTools.setDedicated(tmpFont, true);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("font missing", ex);
            }
        }
        result.setFont(tmpFont);
        float tmpSize = 0.0f;
        if (this.getFontSize() > 0.0f) {
            tmpSize = this.getFontSize();
        }
        if (tmpSize <= 0.0f && defaultTextFormat != null) {
            tmpSize = defaultTextFormat.getFontSize();
        }
        if (tmpSize <= 0.0f) {
            tmpSize = 10.0f;
        }
        result.setFontSize(tmpSize);
        float[] tmpColor = this.getFontColor();
        if (tmpColor == null && defaultTextFormat != null) {
            tmpColor = defaultTextFormat.getFontColor();
        }
        result.setFontColor(PDFColorTools.fixColorValues((float[])tmpColor));
        return result;
    }

    public void setFontColor(float[] fontColor) {
        this.fontColor = fontColor;
    }

    public void setFontFactory(IFontFactory fontFactory) {
        this.fontFactory = fontFactory;
    }

    public void setFontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }
}

