/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.attachment;

import de.intarsys.pdf.app.appearance.markup.attachment.PACKAGE;
import de.intarsys.pdf.app.appearance.markup.common.CommonIcon;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSLiteral;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;

public class GraphIcon
extends CommonIcon {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final COSName TYPE = COSName.constant((String)"Graph");
    protected static final String LITERAL_1 = "0 i 0.39 w 4 M 1 j 0 J []0 d  19.65 0.24 m 0.27 0.24 l 0.27 19.62 l 19.65 19.62 l 19.65 0.24 l h B ";
    protected static final String LITERAL_2 = "9.43 1.35 m 6.34 1.35 l 6.34 10.24 l 9.43 10.24 l 9.43 1.35 l h B 4.98 1.35 m 1.89 1.35 l 1.89 14.53 l 4.98 14.53 l 4.98 1.35 l h B 13.88 1.35 m 10.79 1.35 l 10.79 17.60 l 13.88 17.60 l 13.88 1.35 l h B 18.34 1.35 m 15.24 1.35 l 15.24 13.16 l 18.34 13.16 l 18.34 1.35 l h B ";
    protected static final String LITERAL_3 = "8.89 1.90 m 5.79 1.90 l 5.79 10.78 l 8.89 10.78 l 8.89 1.90 l h B 4.44 1.90 m 1.34 1.90 l 1.34 15.07 l 4.44 15.07 l 4.44 1.90 l h B 13.34 1.90 m 10.25 1.90 l 10.25 18.14 l 13.34 18.14 l 13.34 1.90 l h B 17.79 1.90 m 14.70 1.90 l 14.70 13.70 l 17.79 13.70 l 17.79 1.90 l h B ";

    protected void addLiteral(CSCreator creator, String literal) {
        CSContent content = creator.getContent();
        byte[] literalBytes = StringTools.toByteArray((String)literal);
        CSLiteral literalOP = new CSLiteral(literalBytes);
        content.addOperation((CSOperation)literalOP);
    }

    @Override
    public String getLabel() {
        return Msg.getString("GraphIcon.Label", new Object[0]);
    }

    @Override
    public COSName getName() {
        return TYPE;
    }

    @Override
    protected void writeOn(CSCreator creator, float[] strokeColor, float[] nonStrokeColor, double opacity) {
        PDExtGState extGState = null;
        if (opacity != 1.0) {
            extGState = (PDExtGState)PDExtGState.META.createNew();
            extGState.cosSetField(PDExtGState.DK_AIS, (COSObject)COSBoolean.create((boolean)false));
            extGState.cosSetField(PDExtGState.DK_CA, (COSObject)COSFixed.create((float)((float)opacity)));
            extGState.cosSetField(PDExtGState.DK_ca, (COSObject)COSFixed.create((float)((float)opacity)));
        }
        creator.setNonStrokeColorGray(1.0f);
        if (extGState != null) {
            creator.setExtendedState(null, extGState);
        }
        CSDeviceTools.setStrokeColor((ICSDevice)creator, (float[])strokeColor);
        if (extGState != null) {
            creator.setExtendedState(null, extGState);
        }
        this.addLiteral(creator, LITERAL_1);
        creator.setNonStrokeColorGray(0.0f);
        if (extGState != null) {
            creator.setExtendedState(null, extGState);
        }
        this.addLiteral(creator, LITERAL_2);
        CSDeviceTools.setNonStrokeColor((ICSDevice)creator, (float[])nonStrokeColor);
        if (extGState != null) {
            creator.setExtendedState(null, extGState);
        }
        this.addLiteral(creator, LITERAL_3);
    }
}

