/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.common;

import de.intarsys.pdf.app.appearance.markup.common.IIcon;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDPage;

public abstract class CommonIcon
implements IIcon {
    protected CommonIcon() {
    }

    public PDAppearance createAppearance(PDAnnotation annotation, PDAppearance appearance) {
        if (appearance == null) {
            appearance = PDAnnotationTools.getAppearance((PDAnnotation)annotation);
        }
        float[] strokeColor = new float[]{0.0f};
        float[] nonStrokeColor = annotation.getColor();
        if (nonStrokeColor == null) {
            nonStrokeColor = new float[]{1.0f, 1.0f, 0.0f};
        }
        double opacity = ((PDMarkupAnnotation)annotation).getOpacity();
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.writeForm(normalForm, strokeColor, nonStrokeColor, opacity, annotation);
        PDForm downForm = PDAppearanceTools.getDownAppearance((PDAppearance)appearance, null);
        this.writeForm(downForm, nonStrokeColor, strokeColor, opacity, annotation);
        return appearance;
    }

    public COSName getAnnotationType() {
        return null;
    }

    public String getDescription() {
        return this.getLabel();
    }

    @Override
    public float getHeight() {
        return 20.0f;
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        return this.getName().stringValue();
    }

    public String getTip() {
        return this.getLabel();
    }

    @Override
    public float getWidth() {
        return 20.0f;
    }

    protected void transform(PDPage page, CDSRectangle rect, CDSMatrix matrix) {
        if (page == null) {
            return;
        }
        PDAnnotationTools.transform((CDSRectangle)rect, (CDSMatrix)matrix, (int)page.getNormalizedRotate());
    }

    protected void writeForm(PDForm form, float[] strokeColor, float[] nonStrokeColor, double opacity, PDAnnotation annotation) {
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)form);
        this.writeOn(creator, strokeColor, nonStrokeColor, opacity);
        CSContent content = creator.getContent();
        form.setBytes(content.toByteArray());
        CDSRectangle bbox = new CDSRectangle(0.0f, 0.0f, this.getWidth(), this.getHeight());
        CDSMatrix matrix = new CDSMatrix();
        this.transform(PDAnnotationTools.getPage((PDAnnotation)annotation), bbox, matrix);
        bbox.moveTo(0.0f, 0.0f);
        form.setBoundingBox(bbox);
        form.setMatrix(matrix);
    }

    protected abstract void writeOn(CSCreator var1, float[] var2, float[] var3, double var4);
}

