/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.common;

import de.intarsys.pdf.app.appearance.markup.common.IIcon;
import de.intarsys.pdf.app.appearance.markup.common.IIconSet;
import de.intarsys.pdf.cos.COSName;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class CommonIconSet
implements IIconSet {
    private Map icons = new LinkedHashMap();

    protected CommonIconSet() {
        this.registerStandardIcons();
    }

    @Override
    public IIcon getDefaultIcon() {
        COSName name = this.getDefaultIconName();
        if (name == null) {
            return null;
        }
        return this.lookupIcon(name);
    }

    protected COSName getDefaultIconName() {
        return null;
    }

    @Override
    public List getIcons() {
        return new ArrayList(this.icons.values());
    }

    @Override
    public IIcon lookupIcon(COSName name) {
        return (IIcon)this.icons.get(name);
    }

    @Override
    public void registerIcon(IIcon icon) {
        this.icons.put(icon.getName(), icon);
    }

    protected void registerStandardIcons() {
    }

    @Override
    public void unregisterIcon(IIcon icon) {
        this.icons.remove(icon.getName());
    }
}

