/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.draw;

import de.intarsys.pdf.app.appearance.markup.common.MarkupAppearanceCreator;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDMarkupAnnotation;

public class LineAppearanceCreator
extends MarkupAppearanceCreator {
    private CSCreator creator;

    @Override
    protected void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.creator = CSCreator.createNew((IContentStreamProvider)normalForm);
        COSArray lineArray = annotation.cosGetField(PDMarkupAnnotation.DK_L).asArray();
        if (lineArray == null || lineArray.size() < 4) {
            return;
        }
        float x1 = ((COSNumber)lineArray.get(0)).floatValue();
        float y1 = ((COSNumber)lineArray.get(1)).floatValue();
        float x2 = ((COSNumber)lineArray.get(2)).floatValue();
        float y2 = ((COSNumber)lineArray.get(3)).floatValue();
        float[] borderColor = annotation.getColor();
        if (borderColor == null) {
            borderColor = new float[]{0.0f, 0.0f, 0.0f};
        }
        float width = annotation.getBorderStyleWidth();
        CSDeviceTools.setStrokeColor((ICSDevice)this.creator, (float[])borderColor);
        this.creator.setLineWidth(width);
        this.creator.setLineCap(0);
        this.creator.setLineJoin(0);
        double opacity = ((PDMarkupAnnotation)annotation).getOpacity();
        PDExtGState extGState = null;
        if (opacity != 1.0) {
            extGState = (PDExtGState)PDExtGState.META.createNew();
            extGState.cosSetField(PDExtGState.DK_AIS, (COSObject)COSBoolean.create((boolean)false));
            extGState.cosSetField(PDExtGState.DK_CA, (COSObject)COSFixed.create((float)((float)opacity)));
            extGState.cosSetField(PDExtGState.DK_ca, (COSObject)COSFixed.create((float)((float)opacity)));
            this.creator.setExtendedState(null, extGState);
        }
        this.creator.penMoveTo(x1, y1);
        this.creator.penLineTo(x2, y2);
        this.creator.pathStroke();
        this.creator.close();
        CDSRectangle bbox = annotation.getNormalizedRectangle();
        normalForm.setBoundingBox(bbox);
        CDSMatrix matrix = new CDSMatrix();
        matrix.translate(-bbox.getLowerLeftX(), -bbox.getLowerLeftY());
        normalForm.setMatrix(matrix);
    }

    public COSName getAnnotationType() {
        return PDMarkupAnnotation.CN_Subtype_Line;
    }
}

