/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.draw;

import de.intarsys.pdf.app.appearance.markup.common.MarkupAppearanceCreator;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import java.util.Iterator;

public class PolylineAppearanceCreator
extends MarkupAppearanceCreator {
    private CSCreator creator;

    @Override
    protected void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        COSArray polygon;
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.creator = CSCreator.createNew((IContentStreamProvider)normalForm);
        float[] borderColor = annotation.getColor();
        if (borderColor == null) {
            borderColor = new float[]{0.0f, 0.0f, 0.0f};
        }
        float width = annotation.getBorderStyleWidth();
        CSDeviceTools.setStrokeColor((ICSDevice)this.creator, (float[])borderColor);
        this.creator.setLineWidth(width);
        this.creator.setLineCap(1);
        this.creator.setLineJoin(1);
        double opacity = ((PDMarkupAnnotation)annotation).getOpacity();
        PDExtGState extGState = null;
        if (opacity != 1.0) {
            extGState = (PDExtGState)PDExtGState.META.createNew();
            extGState.cosSetField(PDExtGState.DK_AIS, (COSObject)COSBoolean.create((boolean)false));
            extGState.cosSetField(PDExtGState.DK_CA, (COSObject)COSFixed.create((float)((float)opacity)));
            extGState.cosSetField(PDExtGState.DK_ca, (COSObject)COSFixed.create((float)((float)opacity)));
            this.creator.setExtendedState(null, extGState);
        }
        if ((polygon = annotation.cosGetField(PDMarkupAnnotation.DK_Vertices).asArray()) == null) {
            return;
        }
        boolean move = true;
        Iterator itPolygon = polygon.iterator();
        while (itPolygon.hasNext()) {
            COSNumber cosX = ((COSObject)itPolygon.next()).asNumber();
            if (!itPolygon.hasNext()) break;
            COSNumber cosY = ((COSObject)itPolygon.next()).asNumber();
            if (cosX == null || cosY == null) continue;
            float x = cosX.floatValue();
            float y = cosY.floatValue();
            if (move) {
                this.creator.penMoveTo(x, y);
            } else {
                this.creator.penLineTo(x, y);
            }
            move = false;
        }
        this.creator.pathStroke();
        this.creator.close();
        CDSRectangle bbox = annotation.getNormalizedRectangle();
        normalForm.setBoundingBox(bbox);
        CDSMatrix matrix = new CDSMatrix();
        matrix.translate(-bbox.getLowerLeftX(), -bbox.getLowerLeftY());
        normalForm.setMatrix(matrix);
    }

    public COSName getAnnotationType() {
        return PDMarkupAnnotation.CN_Subtype_PolyLine;
    }
}

