/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.draw;

import de.intarsys.pdf.app.appearance.markup.common.MarkupAppearanceCreator;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDMarkupAnnotation;

public class SquareAppearanceCreator
extends MarkupAppearanceCreator {
    private CSCreator creator;

    @Override
    protected void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.creator = CSCreator.createNew((IContentStreamProvider)normalForm);
        float[] borderColor = annotation.getColor();
        float[] fillColor = ((PDMarkupAnnotation)annotation).getInnerColor();
        float borderWidth = 0.0f;
        if (borderColor != null) {
            borderWidth = annotation.getBorderStyleWidth();
        }
        double opacity = ((PDMarkupAnnotation)annotation).getOpacity();
        PDExtGState extGState = null;
        if (opacity != 1.0) {
            extGState = (PDExtGState)PDExtGState.META.createNew();
            extGState.cosSetField(PDExtGState.DK_AIS, (COSObject)COSBoolean.create((boolean)false));
            extGState.cosSetField(PDExtGState.DK_CA, (COSObject)COSFixed.create((float)((float)opacity)));
            extGState.cosSetField(PDExtGState.DK_ca, (COSObject)COSFixed.create((float)((float)opacity)));
        }
        CDSRectangle rect = annotation.getRectangle().normalize();
        float x = rect.getLowerLeftX() + borderWidth / 2.0f;
        float y = rect.getLowerLeftY() + borderWidth / 2.0f;
        float width = rect.getWidth() - borderWidth;
        float height = rect.getHeight() - borderWidth;
        if (fillColor != null) {
            CSDeviceTools.setNonStrokeColor((ICSDevice)this.creator, (float[])fillColor);
            if (extGState != null) {
                this.creator.setExtendedState(null, extGState);
            }
            this.creator.penRectangle(x, y, width, height);
            this.creator.pathFillNonZero();
        }
        if (borderColor != null && borderWidth > 0.0f) {
            this.creator.setLineWidth(borderWidth);
            this.creator.setLineCap(0);
            this.creator.setLineJoin(0);
            CSDeviceTools.setStrokeColor((ICSDevice)this.creator, (float[])borderColor);
            if (extGState != null) {
                this.creator.setExtendedState(null, extGState);
            }
            this.creator.penRectangle(x, y, width, height);
            this.creator.pathCloseStroke();
        }
        this.creator.close();
        CDSRectangle bbox = annotation.getNormalizedRectangle();
        normalForm.setBoundingBox(bbox);
        CDSMatrix matrix = new CDSMatrix();
        matrix.translate(-rect.getLowerLeftX(), -rect.getLowerLeftY());
        normalForm.setMatrix(matrix);
    }

    public COSName getAnnotationType() {
        return PDMarkupAnnotation.CN_Subtype_Square;
    }
}

