/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.stamp;

import de.intarsys.pdf.app.appearance.markup.stamp.AbstractStampElement;
import de.intarsys.pdf.app.appearance.markup.stamp.StampLibrary;
import de.intarsys.pdf.pd.PDForm;

public class Stamp
extends AbstractStampElement {
    private String realName;
    private String name;
    private String label;
    private PDForm form;
    private StampLibrary library;

    public static String extractLabel(String fullName) {
        if (fullName != null) {
            String[] fragments = fullName.split("=");
            if (fragments != null && fragments.length > 1) {
                return fragments[1];
            }
            if (fragments != null && fragments.length > 0) {
                return fragments[0];
            }
        }
        return null;
    }

    public static String extractName(String fullName) {
        String[] fragments;
        if (fullName != null && (fragments = fullName.split("=")) != null && fragments.length > 0) {
            return fragments[0];
        }
        return null;
    }

    public Stamp(StampLibrary library) {
        this.library = library;
    }

    public PDForm getForm() {
        return this.form;
    }

    public String getFullName() {
        if (this.label == null) {
            return this.getName();
        }
        return this.getName() + "=" + this.getLabel();
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getName();
        }
        return this.label;
    }

    public StampLibrary getLibrary() {
        return this.library;
    }

    public String getName() {
        return this.name;
    }

    public String getRealName() {
        return this.realName;
    }

    protected void setForm(PDForm form) {
        form.cosGetObject().beConstant();
        this.form = form;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected void setName(String pName) {
        this.name = pName;
    }

    protected void setRealName(String pName) {
        this.realName = pName;
        this.setName(Stamp.extractName(pName));
        this.setLabel(Stamp.extractLabel(pName));
    }
}

