/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.stamp;

import de.intarsys.pdf.app.appearance.markup.common.MarkupAppearanceCreator;
import de.intarsys.pdf.app.appearance.markup.stamp.Stamp;
import de.intarsys.pdf.app.appearance.markup.stamp.StampRegistry;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDStampAnnotation;

public class StampAppearanceCreator
extends MarkupAppearanceCreator {
    @Override
    protected void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        int rotation;
        PDForm form = appearance.getNormalAppearance(null);
        if (form == null) {
            Stamp stamp;
            StampRegistry registry;
            COSName name = ((PDStampAnnotation)annotation).getIconName();
            if (name == null) {
                name = PDStampAnnotation.CN_DRAFT;
            }
            if ((registry = StampRegistry.get()) != null && (stamp = registry.lookupStamp(name.stringValue())) != null) {
                form = stamp.getForm();
            }
            if (form == null) {
                form = StampRegistry.getNotFoundForm(name.stringValue());
            }
            appearance.setNormalAppearance(null, form);
        }
        if ((rotation = this.getRotation(annotation)) != 0) {
            CDSMatrix matrix = form.getMatrix();
            if (matrix == null) {
                matrix = new CDSMatrix();
                form.setMatrix(matrix);
            }
            matrix.rotate((float)rotation / 180.0f * (float)Math.PI);
        }
    }

    public COSName getAnnotationType() {
        return PDStampAnnotation.CN_Subtype_Stamp;
    }
}

