/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.stamp;

import de.intarsys.pdf.app.appearance.markup.stamp.AbstractStampElement;
import de.intarsys.pdf.app.appearance.markup.stamp.PACKAGE;
import de.intarsys.pdf.app.appearance.markup.stamp.Stamp;
import de.intarsys.pdf.cds.CDSNameTreeEntry;
import de.intarsys.pdf.cds.CDSNameTreeNode;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.common.CSContentTools;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StampLibrary
extends AbstractStampElement {
    public static final String ATTR_READ_ONLY = "readOnly";
    public static final String ATTR_STAMPS = "stamps";
    public static final String ATTR_NAME = "name";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static IMessage libraryName = Msg.getMessage("StampLibrary.NewLibraryName", new Object[0]);
    private boolean readOnly = false;
    private List stamps;
    private String namePrefix;
    private ILocator locator;

    protected static File createFileName(File dir) {
        File result = new File(dir, libraryName.getString() + ".pdf");
        int i = 1;
        while (result.exists()) {
            result = new File(dir, libraryName.getString() + " [" + i++ + "].pdf");
        }
        return result;
    }

    public static StampLibrary createNewLibrary(File libDir) throws IOException {
        try {
            FileTools.checkDirectory((File)libDir, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (IOException e) {
            String msg = Msg.getString("StampLibrary.ExIOCheckDirectory", new Object[]{libDir.getAbsolutePath()});
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
        File libFile = StampLibrary.createFileName(libDir);
        FileLocator locator = new FileLocator(libFile);
        PDDocument pddoc = PDDocument.createNew();
        PDPage dummyPage = (PDPage)PDPage.META.createNew();
        pddoc.addPageNode((PDPageNode)dummyPage);
        try {
            pddoc.save((ILocator)locator);
            pddoc.close();
        }
        catch (IOException e) {
            String msg = Msg.getString("StampLibrary.ExIOSave", new Object[0]);
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
        return new StampLibrary((ILocator)locator);
    }

    public StampLibrary(ILocator locator) {
        this.locator = locator;
    }

    public void addStamp(String name, PDDocument stampDoc, int pageIndex) throws IOException {
        this.init();
        if (this.lookupStamp(name) != null) {
            String msg = Msg.getString("StampLibrary.ExStampAlreadyAvailable", new Object[]{name});
            throw new IOException(msg);
        }
        PDDocument doc = null;
        try {
            PDPage sourcePage = stampDoc.getPageTree().getPageAt(pageIndex);
            if (sourcePage == null) {
                return;
            }
            doc = PDDocument.createFromLocator((ILocator)this.getLocator());
            CDSNameTreeNode pageNames = this.getPageNames(doc);
            COSString cosName = COSString.create((String)name);
            PDPage page = (PDPage)PDPage.META.createNew();
            CSContent content = sourcePage.getContentStream();
            page.setContentStream(content);
            if (sourcePage.getResources() != null) {
                COSObject cosResources = sourcePage.getResources().cosGetObject().copyDeep();
                PDResources resources = (PDResources)PDResources.META.createFromCos(cosResources);
                page.setResources(resources);
            }
            page.setRotate(sourcePage.getRotate());
            doc.addPageNode((PDPageNode)page);
            pageNames.put(cosName, page.cosGetObject());
            doc.save();
            Stamp newStamp = this.createStamp(name, page.cosGetObject());
            this.stamps.add(newStamp);
            this.triggerChanged(ATTR_STAMPS, null, newStamp);
        }
        catch (IOException e) {
            String msg = Msg.getString("StampLibrary.ExIOSave", new Object[0]);
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
        catch (Exception e) {
            String msg = Msg.getString("StampLibrary.ExUnexpected", new Object[0]);
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            try {
                if (doc != null) {
                    doc.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected Stamp createStamp(String name, COSObject cosPage) {
        PDPage page = (PDPage)PDPage.META.createFromCos(cosPage);
        if (page != null) {
            PDForm form = CSContentTools.getFormClipped((PDPage)page, (double)0.0);
            Stamp stamp = new Stamp(this);
            stamp.setForm(form);
            stamp.setRealName(name);
            return stamp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List createStamps() {
        PDDocument doc = null;
        try {
            doc = PDDocument.createFromLocator((ILocator)this.getLocator());
            ArrayList<Stamp> result = new ArrayList<Stamp>();
            CDSNameTreeNode pageNames = this.getPageNames(doc);
            if (pageNames != null) {
                for (CDSNameTreeEntry entry : pageNames) {
                    COSObject cosPage;
                    String name = entry.getName().stringValue();
                    Stamp stamp = this.createStamp(name, cosPage = entry.getValue());
                    if (stamp == null) continue;
                    result.add(stamp);
                }
            }
            ArrayList<Stamp> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            try {
                if (doc != null) {
                    doc.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getFullName() {
        if (this.getNamePrefix() == null) {
            return this.getName();
        }
        return this.getNamePrefix() + this.getName();
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getName() {
        return LocatorTools.getBaseName((ILocator)this.getLocator());
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    protected CDSNameTreeNode getPageNames(PDDocument doc) {
        CDSNameTreeNode pageNameTree;
        COSDictionary pages;
        COSDictionary names = doc.getCatalog().cosGetNames();
        if (names == null) {
            names = COSDictionary.create();
            doc.getCatalog().cosSetNames(names);
        }
        if ((pages = names.get(COSCatalog.DK_Pages).asDictionary()) == null) {
            pageNameTree = CDSNameTreeNode.createRootLeaf();
            names.put(COSCatalog.DK_Pages, pageNameTree.cosGetObject());
        } else {
            pageNameTree = CDSNameTreeNode.createFromCos((COSDictionary)pages);
        }
        return pageNameTree;
    }

    public List getStamps() {
        this.init();
        return new ArrayList(this.stamps);
    }

    protected synchronized void init() {
        if (this.stamps == null) {
            this.stamps = this.createStamps();
        }
    }

    public boolean isReadOnly() {
        return this.readOnly || this.locator == null || this.locator.isReadOnly();
    }

    public Stamp lookupStamp(String fullName) {
        List tempStamps = this.getStamps();
        String name = Stamp.extractName(fullName);
        for (Stamp stamp : tempStamps) {
            if (!stamp.getName().equals(name)) continue;
            return stamp;
        }
        String label = Stamp.extractLabel(fullName);
        for (Stamp stamp : tempStamps) {
            if (!stamp.getLabel().equals(label)) continue;
            return stamp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStamp(Stamp stamp) throws IOException {
        StampLibrary stampLibrary = this;
        synchronized (stampLibrary) {
            this.init();
            this.stamps.remove(stamp);
        }
        PDDocument doc = null;
        try {
            doc = PDDocument.createFromLocator((ILocator)this.getLocator());
            CDSNameTreeNode pageNames = this.getPageNames(doc);
            COSString cosName = COSString.create((String)stamp.getRealName());
            COSObject cosPage = pageNames.get(cosName);
            PDPage page = (PDPage)PDPage.META.createFromCos(cosPage);
            if (page != null) {
                page.dispose();
            }
            pageNames.remove(cosName);
            doc.save();
        }
        catch (IOException e) {
            String msg = Msg.getString("StampLibrary.ExIOSave", new Object[0]);
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
        catch (Exception e) {
            String msg = Msg.getString("StampLibrary.ExUnexpected", new Object[0]);
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            try {
                if (doc != null) {
                    doc.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.triggerChanged(ATTR_STAMPS, stamp, null);
    }

    public void rename(String newName) throws IOException {
        newName = PathTools.getBaseName((String)newName) + ".pdf";
        String oldValue = this.getName();
        this.getLocator().rename((String)newName);
        this.triggerChanged(ATTR_NAME, oldValue, this.getName());
    }

    public void renameStamp(Stamp stamp, String newName) throws IOException {
        PDDocument doc = null;
        Stamp previous = this.lookupStamp(newName);
        if (previous != null && previous != stamp) {
            String msg = Msg.getString("StampLibrary.ExStampAlreadyAvailable", new Object[]{newName});
            throw new IOException(msg);
        }
        try {
            doc = PDDocument.createFromLocator((ILocator)this.getLocator());
            CDSNameTreeNode pageNames = this.getPageNames(doc);
            COSString cosOldName = COSString.create((String)stamp.getRealName());
            COSString cosNewName = COSString.create((String)newName);
            COSObject cosPage = pageNames.remove(cosOldName);
            if (!cosPage.isNull()) {
                pageNames.put(cosNewName, cosPage);
                stamp.setRealName(newName);
            }
            doc.save();
        }
        catch (IOException e) {
            String msg = Msg.getString("StampLibrary.ExIOSave", new Object[0]);
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
        catch (Exception e) {
            String msg = Msg.getString("StampLibrary.ExUnexpected", new Object[0]);
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            try {
                if (doc != null) {
                    doc.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setNamePrefix(String pNamePrefix) {
        String oldValue = this.getName();
        this.namePrefix = pNamePrefix;
        this.triggerChanged(ATTR_NAME, oldValue, this.getName());
    }

    public void setReadOnly(boolean pReadOnly) {
        boolean oldValue = this.readOnly;
        this.readOnly = pReadOnly;
        this.triggerChanged(ATTR_READ_ONLY, oldValue, pReadOnly);
    }
}

