/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.stamp;

import de.intarsys.pdf.app.appearance.markup.stamp.AbstractStampElement;
import de.intarsys.pdf.app.appearance.markup.stamp.Stamp;
import de.intarsys.pdf.app.appearance.markup.stamp.StampLibrary;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDFormTools;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.tools.component.SingletonClass;
import java.util.ArrayList;
import java.util.List;

@SingletonClass
public class StampRegistry
extends AbstractStampElement {
    private static final StampRegistry ACTIVE = new StampRegistry();
    public static final String ATTR_LIBRARIES = "libraries";
    private List libraries = new ArrayList();

    protected static PDForm createNotFound(String value) {
        PDForm result = (PDForm)PDForm.META.createNew();
        StringBuilder sb = new StringBuilder();
        sb.append("q ");
        sb.append("1 0 0 1 80.03999 756.98 cm ");
        sb.append("0.5 G ");
        sb.append("0.75 w ");
        sb.append("1 j ");
        sb.append("1 J ");
        sb.append("0 0 m ");
        sb.append("-3.9 0 -7.08 -3.18 -7.08 -7.08 c ");
        sb.append("-7.08 -35.4 l ");
        sb.append("-7.08 -39.36 -3.9 -42.48 0 -42.48 c ");
        sb.append("127.62 -42.48 l ");
        sb.append("131.52 -42.48 134.7 -39.36 134.7 -35.4 c ");
        sb.append("134.7 -7.08 l ");
        sb.append("134.7 -3.18 131.52 0 127.62 0 c ");
        sb.append("h ");
        sb.append("S ");
        sb.append("Q ");
        sb.append("BT ");
        sb.append("0.36 w ");
        sb.append("1 M ");
        sb.append("0.7 G ");
        sb.append("/F01 1 Tf ");
        sb.append("-0.0099 Tc ");
        sb.append("2 Tr ");
        sb.append("18 0 0 18 98.58 729.3803 Tm ");
        sb.append("(");
        sb.append(value);
        sb.append(") Tj ");
        sb.append("ET ");
        result.setBytes(sb.toString().getBytes());
        CDSMatrix matrix = new CDSMatrix(new float[]{1.0f, 0.0f, 0.0f, 1.0f, -67.21f, -708.75f});
        result.setMatrix(matrix);
        CDSRectangle bbox = new CDSRectangle(new float[]{67.21f, 708.75f, 220.4f, 762.73f});
        result.setBoundingBox(bbox);
        PDResources resources = PDFormTools.getResources((PDForm)result);
        resources.addFontResource(COSName.create((String)"F01"), PDFontTools.createBuiltinFont((String)"Helvetica"));
        return result;
    }

    public static StampRegistry get() {
        return ACTIVE;
    }

    public static PDForm getNotFoundForm(String value) {
        return StampRegistry.createNotFound(value);
    }

    public synchronized List getLibraries() {
        return new ArrayList(this.libraries);
    }

    public synchronized StampLibrary lookupLibrary(String name) {
        for (StampLibrary library : this.libraries) {
            if (!library.getFullName().equals(name)) continue;
            return library;
        }
        return null;
    }

    public synchronized Stamp lookupStamp(String name) {
        Stamp stamp;
        StampLibrary library;
        String[] names = name.split("\\.", 2);
        if (names.length == 2 && (library = this.lookupLibrary(names[0])) != null && (stamp = library.lookupStamp(names[1])) != null) {
            return stamp;
        }
        for (StampLibrary library2 : this.libraries) {
            Stamp stamp2 = library2.lookupStamp(name);
            if (stamp2 == null) continue;
            return stamp2;
        }
        return null;
    }

    public synchronized void registerLibrary(StampLibrary library) {
        this.libraries.add(library);
        this.triggerChanged(ATTR_LIBRARIES, null, library);
    }

    public synchronized void unregisterLibrary(StampLibrary library) {
        if (this.libraries.remove(library)) {
            this.triggerChanged(ATTR_LIBRARIES, library, null);
        }
    }
}

