/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.textnote;

import de.intarsys.pdf.app.appearance.markup.common.MarkupAppearanceCreator;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDTextMarkupAnnotation;

public class HighlightAppearanceCreator
extends MarkupAppearanceCreator {
    private CSCreator creator;

    @Override
    protected void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        PDTextMarkupAnnotation markupAnnotation = (PDTextMarkupAnnotation)annotation;
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.creator = CSCreator.createNew((IContentStreamProvider)normalForm);
        float[] color = markupAnnotation.getColor();
        double opacity = markupAnnotation.getOpacity();
        PDExtGState extGState = (PDExtGState)PDExtGState.META.createNew();
        extGState.setBlendModeMultiply();
        extGState.cosSetField(PDExtGState.DK_AIS, (COSObject)COSBoolean.create((boolean)false));
        if (opacity != 1.0) {
            extGState.cosSetField(PDExtGState.DK_CA, (COSObject)COSFixed.create((float)((float)opacity)));
            extGState.cosSetField(PDExtGState.DK_ca, (COSObject)COSFixed.create((float)((float)opacity)));
        }
        this.creator.setExtendedState(null, extGState);
        float[] quadPoints = markupAnnotation.getQuadPoints();
        if (quadPoints != null && color != null) {
            int i = 0;
            while (i < quadPoints.length) {
                float x1 = quadPoints[i++];
                float y1 = quadPoints[i++];
                float x2 = quadPoints[i++];
                float y2 = quadPoints[i++];
                float x3 = quadPoints[i++];
                float y3 = quadPoints[i++];
                float x4 = quadPoints[i++];
                float y4 = quadPoints[i++];
                CSDeviceTools.setNonStrokeColor((ICSDevice)this.creator, (float[])color);
                this.creator.penMoveTo(x1, y1);
                this.creator.penLineTo(x2, y2);
                this.creator.penLineTo(x4, y4);
                this.creator.penLineTo(x3, y3);
                this.creator.pathClose();
                this.creator.pathFillNonZero();
            }
        }
        CDSRectangle rect = annotation.getRectangle().normalize();
        this.creator.close();
        CDSRectangle bbox = annotation.getNormalizedRectangle();
        normalForm.setBoundingBox(bbox);
        CDSMatrix matrix = new CDSMatrix();
        matrix.translate(-rect.getLowerLeftX(), -rect.getLowerLeftY());
        normalForm.setMatrix(matrix);
    }

    public COSName getAnnotationType() {
        return PDTextMarkupAnnotation.CN_Subtype_Highlight;
    }
}

