/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.markup.textnote;

import de.intarsys.pdf.app.appearance.markup.common.MarkupAppearanceCreator;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDTextMarkupAnnotation;

public class UnderlineAppearanceCreator
extends MarkupAppearanceCreator {
    private static final int DEG_360 = 360;
    private static final int DEG_270 = 270;
    private static final int DEG_180 = 180;
    private static final int DEG_90 = 90;

    @Override
    protected void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        PDTextMarkupAnnotation markupAnnotation = (PDTextMarkupAnnotation)annotation;
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)normalForm);
        float[] color = markupAnnotation.getColor();
        double opacity = markupAnnotation.getOpacity();
        PDExtGState extGState = null;
        if (opacity != 1.0) {
            extGState = (PDExtGState)PDExtGState.META.createNew();
            extGState.cosSetField(PDExtGState.DK_AIS, (COSObject)COSBoolean.create((boolean)false));
            extGState.cosSetField(PDExtGState.DK_CA, (COSObject)COSFixed.create((float)((float)opacity)));
            extGState.cosSetField(PDExtGState.DK_ca, (COSObject)COSFixed.create((float)((float)opacity)));
        }
        int rotation = this.getRotation(annotation);
        float[] quadPoints = markupAnnotation.getQuadPoints();
        if (quadPoints != null && color != null) {
            int i = 0;
            while (i < quadPoints.length) {
                float x1 = quadPoints[i++];
                float y1 = quadPoints[i++];
                float x2 = quadPoints[i++];
                float y2 = quadPoints[i++];
                float x3 = quadPoints[i++];
                float y3 = quadPoints[i++];
                float x4 = quadPoints[i++];
                float y4 = quadPoints[i++];
                CSDeviceTools.setStrokeColor((ICSDevice)creator, (float[])color);
                if (extGState != null) {
                    creator.setExtendedState(null, extGState);
                }
                float xa = x3;
                float ya = y3;
                float xb = x4;
                float yb = y4;
                if (rotation % 360 == 90) {
                    xa = x2;
                    ya = y2;
                    xb = x4;
                    yb = y4;
                } else if (rotation % 360 == 180) {
                    xa = x1;
                    ya = y1;
                    xb = x2;
                    yb = y2;
                } else if (rotation % 360 == 270) {
                    xa = x3;
                    ya = y3;
                    xb = x1;
                    yb = y1;
                }
                creator.penMoveTo(xa, ya);
                creator.penLineTo(xb, yb);
                creator.pathStroke();
            }
        }
        CDSRectangle rect = annotation.getRectangle().normalize();
        creator.close();
        CDSRectangle bbox = annotation.getNormalizedRectangle();
        normalForm.setBoundingBox(bbox);
        CDSMatrix matrix = new CDSMatrix();
        matrix.translate(-rect.getLowerLeftX(), -rect.getLowerLeftY());
        normalForm.setMatrix(matrix);
    }

    public COSName getAnnotationType() {
        return PDTextMarkupAnnotation.CN_Subtype_Underline;
    }
}

