/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.widget;

import de.intarsys.pdf.app.appearance.widget.StatefulAppearanceStaticCreator;
import de.intarsys.pdf.app.xmp.XMPTools;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDWidgetAnnotation;

public class CheckboxAppearanceStaticCreator
extends StatefulAppearanceStaticCreator {
    @Override
    public void createAppearance(PDAnnotation annotation, COSName state, PDAppearance appearance) {
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, (COSName)state);
        this.createAppearanceStream(widget, normalForm, PDAnnotationTools.getBorderColor((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColor((PDWidgetAnnotation)widget), PDAnnotationTools.isStateChecked((COSName)state));
        PDDocument document = annotation.getDoc();
        if (document == null || !XMPTools.claimsPDFACompliance(document)) {
            PDForm downForm = PDAppearanceTools.getDownAppearance((PDAppearance)appearance, (COSName)state);
            this.createAppearanceStream(widget, downForm, PDAnnotationTools.getBorderColorNegative((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColorNegative((PDWidgetAnnotation)widget), PDAnnotationTools.isStateChecked((COSName)state));
        }
    }

    protected void createAppearanceStream(PDWidgetAnnotation annotation, PDForm form, float[] borderColor, float[] fillColor, boolean checked) {
        this.initializeBoundingBox(form, (PDAnnotation)annotation);
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)form);
        float borderWidth = annotation.getBorderStyleWidth();
        COSName borderStyleName = annotation.getBorderStyleName();
        CDSRectangle boundingBox = form.getBoundingBox();
        this.drawWidgetRect(creator, boundingBox, borderColor, fillColor, borderWidth, borderStyleName);
        if (checked) {
            String captionString;
            CDSRectangle textRect = new CDSRectangle(boundingBox.getLowerLeftX() + borderWidth, boundingBox.getLowerLeftY() + borderWidth, boundingBox.getUpperRightX() - borderWidth, boundingBox.getUpperRightY() - borderWidth);
            PDAppearanceCharacteristics apc = annotation.getAppearanceCharacteristics();
            if (apc == null) {
                apc = PDAppearanceCharacteristics.META.createNew();
            }
            if ("8".equals(captionString = apc.getNormalCaption())) {
                this.drawWidgetCrossCheckmark(creator, annotation, textRect);
            } else {
                this.drawWidgetCheckmark(creator, annotation, textRect, this.getNormalCaption(annotation));
            }
        }
        creator.close();
    }

    protected void drawWidgetCrossCheckmark(CSCreator creator, PDWidgetAnnotation annotation, CDSRectangle rect) {
        float width = 2.0f;
        float distFactor = 0.1f;
        creator.setLineWidth(width);
        CSDeviceTools.setStrokeColor((ICSDevice)creator, (float[])this.getFontColor(annotation));
        creator.penMoveTo(rect.getLowerLeftX() + distFactor * rect.getWidth(), rect.getLowerLeftY() + distFactor * rect.getHeight());
        creator.penLineTo(rect.getUpperRightX() - distFactor * rect.getWidth(), rect.getUpperRightY() - distFactor * rect.getHeight());
        creator.pathStroke();
        creator.penMoveTo(rect.getLowerLeftX() + distFactor * rect.getWidth(), rect.getUpperRightY() - distFactor * rect.getHeight());
        creator.penLineTo(rect.getUpperRightX() - distFactor * rect.getWidth(), rect.getLowerLeftY() + distFactor * rect.getHeight());
        creator.pathStroke();
    }

    protected String getNormalCaption(PDWidgetAnnotation annotation) {
        String caption = annotation.getAppearanceCharacteristics().getNormalCaption();
        if (caption == null) {
            caption = "4";
        }
        return caption;
    }
}

