/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.widget;

import de.intarsys.layout.CAlignment;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.pdf.app.appearance.ITextFormatProvider;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.layout.pad.PDLLayouter;
import de.intarsys.pdf.layout.pad.PDLParagraphFormat;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.layout.pad.PDLTextPad;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.tools.kernel.PDFColorTools;
import java.awt.geom.Rectangle2D;

public class LayoutTools {
    public static PDLLayouter createLayouter(PDWidgetAnnotation annot) {
        PDAcroFormField formfield = annot.getAcroFormField();
        float fontSize = formfield.getDefaultAppearanceFontSize();
        return LayoutTools.createLayouter(annot, fontSize);
    }

    public static PDLLayouter createLayouter(PDWidgetAnnotation annot, float fontSize) {
        PDAcroFormField field = annot.getAcroFormField();
        CDSRectangle bbox = annot.getNormalizedRectangle();
        CDSMatrix matrix = new CDSMatrix();
        annot.transform(bbox, matrix);
        bbox.moveTo(0.0f, 0.0f);
        float borderWidth = LayoutTools.getBorderWidth(annot);
        bbox.move(borderWidth, borderWidth);
        bbox.resize(-2.0f * borderWidth, -2.0f * borderWidth);
        if (!field.isComb()) {
            bbox.move(1.0f, 2.0f);
            bbox.resize(-2.0f, -4.0f);
        }
        Rectangle2D rect = bbox.toRectangle();
        if (field.isMultiline()) {
            yOffset = LayoutTools.getScaledDescent(field, fontSize);
            rect.setRect(rect.getMinX(), rect.getMinY() + (double)(yOffset -= LayoutTools.getScaledLeading(field, fontSize)), rect.getWidth(), rect.getHeight());
        } else {
            yOffset = LayoutTools.getScaledDescent(field, fontSize);
            rect.setRect(rect.getMinX(), rect.getMinY() + (double)yOffset, rect.getWidth(), rect.getHeight());
        }
        PDLLayouter result = new PDLLayouter(rect);
        if (field.isComb()) {
            result.getLayouter().setPrimaryBorderPolicy(CBorderPolicy.GROW);
        }
        return result;
    }

    public static PDLTextPad createPad(PDAcroFormField field) {
        Integer max;
        PDWidgetAnnotation annot = null;
        PDWidgetAnnotation hiddenAnnot = null;
        float width = Float.MAX_VALUE;
        float hiddenWidth = Float.MAX_VALUE;
        for (Object object : field.getAnnotations()) {
            if (!(object instanceof PDWidgetAnnotation)) continue;
            PDWidgetAnnotation currentAnnot = (PDWidgetAnnotation)object;
            CDSRectangle bbox = currentAnnot.getNormalizedRectangle();
            currentAnnot.transform(bbox, new CDSMatrix());
            if (currentAnnot.isHidden()) {
                if (!(bbox.getWidth() < hiddenWidth)) continue;
                hiddenAnnot = currentAnnot;
                hiddenWidth = bbox.getWidth();
                continue;
            }
            if (!(bbox.getWidth() < width)) continue;
            annot = currentAnnot;
            width = bbox.getWidth();
        }
        if (annot == null) {
            annot = hiddenAnnot;
            width = hiddenWidth;
        }
        if (annot == null) {
            throw new IllegalStateException("annotation is required");
        }
        PDLParagraphFormat paragraphFormat = LayoutTools.createParagraphFormat(annot);
        PDLTextFormat textFormat = LayoutTools.createTextFormat(annot);
        if (field.isComb() && (max = field.getMaxLen()) != null) {
            textFormat.setFixedWidth(width / (float)max.intValue());
        }
        PDLLayouter layouter = LayoutTools.createLayouter(annot);
        return new PDLTextPad(textFormat, paragraphFormat, layouter);
    }

    public static PDLTextPad createPad(PDWidgetAnnotation annot) {
        PDAcroFormField formfield = annot.getAcroFormField();
        float fontSize = formfield.getDefaultAppearanceFontSize();
        return LayoutTools.createPad(annot, fontSize);
    }

    public static PDLTextPad createPad(PDWidgetAnnotation annotation, CDSRectangle rect) {
        PDLTextFormat textFormat = LayoutTools.createTextFormat(annotation);
        if (textFormat.getFont() == null) {
            textFormat.setFont(PDFontTools.createBuiltinFont((String)"Helvetica"));
        }
        PDLParagraphFormat paragraphFormat = new PDLParagraphFormat();
        paragraphFormat.setHAlignment(CAlignment.CENTER);
        paragraphFormat.setVAlignment(CAlignment.CENTER);
        paragraphFormat.setMaxlines(1);
        PDLLayouter layouter = new PDLLayouter(rect.toNormalizedRectangle());
        PDLTextPad pad = new PDLTextPad(textFormat, paragraphFormat, layouter);
        return pad;
    }

    public static PDLTextPad createPad(PDWidgetAnnotation annot, float fontSize) {
        Integer max;
        PDLTextFormat textFormat = LayoutTools.createTextFormat(annot, fontSize);
        if (annot.getAcroFormField().isComb() && (max = annot.getAcroFormField().getMaxLen()) != null) {
            CDSRectangle bbox = annot.getNormalizedRectangle();
            CDSMatrix matrix = new CDSMatrix();
            annot.transform(bbox, matrix);
            textFormat.setFixedWidth(bbox.getWidth() / (float)max.intValue());
        }
        PDLParagraphFormat paragraphFormat = LayoutTools.createParagraphFormat(annot);
        PDLLayouter layouter = LayoutTools.createLayouter(annot, fontSize);
        return new PDLTextPad(textFormat, paragraphFormat, layouter);
    }

    public static PDLParagraphFormat createParagraphFormat(PDWidgetAnnotation annot) {
        PDLParagraphFormat result = new PDLParagraphFormat();
        PDAcroFormField field = annot.getAcroFormField();
        if (field.isMultiline()) {
            result.setMaxlines(-1);
        } else {
            result.setMaxlines(1);
        }
        result.setHAlignment(LayoutTools.getHAlignCode(field));
        result.setVAlignment(LayoutTools.getVAlignCode(field));
        return result;
    }

    public static PDLTextFormat createTextFormat(ITextFormatProvider textFormatProvider) {
        PDLTextFormat result = new PDLTextFormat();
        result.setFont(textFormatProvider.getFont());
        result.setFontSize(textFormatProvider.getFontSize());
        result.setColor(textFormatProvider.getFontColor());
        return result;
    }

    public static PDLTextFormat createTextFormat(PDAcroFormField formfield) {
        float fontSize = formfield.getDefaultAppearanceFontSize();
        return LayoutTools.createTextFormat(formfield, fontSize);
    }

    public static PDLTextFormat createTextFormat(PDAcroFormField formfield, float fontSize) {
        COSName fontName = formfield.getDefaultAppearanceFontName();
        PDResources defaultResources = formfield.getAcroForm().getDefaultResources();
        PDFont font = PDFontTools.getFont((PDDocument)formfield.getDoc(), (PDResources)defaultResources, (COSName)fontName);
        float[] color = formfield.getDefaultAppearanceFontColor();
        color = PDFColorTools.fixColorValues((float[])color);
        if (font == null) {
            font = formfield.getAcroForm().getDefaultAppearanceFont();
        }
        PDLTextFormat result = new PDLTextFormat();
        result.setFont(font);
        result.setFontSize(fontSize);
        result.setColor(color);
        return result;
    }

    public static PDLTextFormat createTextFormat(PDWidgetAnnotation annot) {
        PDAcroFormField formfield = annot.getAcroFormField();
        return LayoutTools.createTextFormat(formfield);
    }

    public static PDLTextFormat createTextFormat(PDWidgetAnnotation annot, float fontSize) {
        PDAcroFormField formfield = annot.getAcroFormField();
        return LayoutTools.createTextFormat(formfield, fontSize);
    }

    protected static float getBorderWidth(PDWidgetAnnotation annot) {
        PDAppearanceCharacteristics appChar;
        float borderWidth = annot.getBorderStyleWidth();
        if (borderWidth != 0.0f && ((appChar = annot.getAppearanceCharacteristics()) == null || appChar.getBorderColor() == null)) {
            borderWidth = 0.0f;
        }
        return borderWidth;
    }

    protected static int getHAlignCode(PDAcroFormField field) {
        int result = CAlignment.LEFT;
        result = field.isAlignmentCenter() ? CAlignment.CENTER : (field.isAlignmentRight() ? CAlignment.RIGHT : CAlignment.LEFT);
        return result;
    }

    public static float getScaledDescent(PDAcroFormField field, float fontSize) {
        PDFont font = field.getDefaultAppearanceFont();
        PDFontDescriptor fd = font.getFontDescriptor();
        float descent = fd.getDescent();
        if (descent == 0.0f) {
            descent = fd.getFontBB().getLowerLeftY();
        }
        float yOffset = -(fontSize * descent / 1000.0f);
        return yOffset;
    }

    protected static float getScaledLeading(PDAcroFormField field, float fontSize) {
        PDFont font = field.getDefaultAppearanceFont();
        PDFontDescriptor fd = font.getFontDescriptor();
        if (fd == null) {
            return 0.0f;
        }
        float leading = 0.0f;
        leading = fd.getFontBB().getUpperRightY() - fd.getFontBB().getLowerLeftY();
        leading -= fd.getAscent();
        leading += fd.getDescent();
        leading /= 1000.0f;
        return leading *= fontSize;
    }

    protected static int getVAlignCode(PDAcroFormField field) {
        int result = CAlignment.TOP;
        result = field.isMultiline() ? CAlignment.TOP : CAlignment.CENTER;
        return result;
    }

    private LayoutTools() {
    }
}

