/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.widget;

import de.intarsys.pdf.app.appearance.widget.LayoutTools;
import de.intarsys.pdf.app.appearance.widget.WidgetAppearanceValueCreator;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.pd.IResourcesProvider;
import de.intarsys.pdf.pd.PDAFChoiceField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.tools.kernel.PDFColorTools;
import java.util.Iterator;
import java.util.List;

public class ListAppearanceValueCreator
extends WidgetAppearanceValueCreator {
    @Override
    protected void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDAFChoiceField field = (PDAFChoiceField)widget.getAcroFormField();
        PDForm normalForm = this.createNormalAppearance((PDAnnotation)widget, appearance);
        CSContent content = CSContent.createNew();
        CSCreator creator = CSCreator.createFromContent((CSContent)content, (IResourcesProvider)normalForm);
        PDLTextFormat textFormat = LayoutTools.createTextFormat(widget);
        creator.saveState();
        CSContent da = field.getDefaultAppearanceContent();
        if (da != null) {
            creator.copy(da);
        }
        PDFont font = textFormat.getFont();
        float fontSize = textFormat.getFontSize();
        if (fontSize == 0.0f) {
            fontSize = 12.0f;
            textFormat.setFontSize(fontSize);
        }
        float[] textColor = textFormat.getColor();
        if ((textColor = PDFColorTools.fixColorValues((float[])textColor)) == null) {
            textColor = new float[]{0.0f, 0.0f, 0.0f};
        }
        float leading = textFormat.getScaledFontHeight();
        float y = normalForm.getBoundingBox().getHeight() - leading;
        float descent = textFormat.getScaledFontDescent();
        float width = normalForm.getBoundingBox().getWidth();
        creator.textSetFont(null, font, fontSize);
        List selection = field.getValueList();
        Iterator itValues = field.getExportValues().iterator();
        Iterator itNames = field.getOptionNames().iterator();
        while (itValues.hasNext()) {
            String value = (String)itValues.next();
            String name = (String)itNames.next();
            if (selection.contains(value)) {
                creator.setNonStrokeColorGray(0.7f);
                creator.penRectangle(0.0f, y + descent, width, leading);
                creator.pathFillEvenOdd();
                creator.setNonStrokeColorGray(0.0f);
            } else {
                CSDeviceTools.setNonStrokeColor((ICSDevice)creator, (float[])textColor);
            }
            creator.textSetTransform(1.0f, 0.0f, 0.0f, 1.0f, 2.0f, y);
            creator.textShow(name);
            y -= leading;
        }
        creator.restoreState();
        creator.close();
        normalForm.setMarkedContent(creator.getContent().toByteArray());
    }
}

