/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.widget;

import de.intarsys.pdf.app.appearance.common.AppearanceTools;
import de.intarsys.pdf.app.appearance.widget.LayoutTools;
import de.intarsys.pdf.app.appearance.widget.WidgetAppearanceStaticCreator;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLTextPad;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.layout.parser.PDLTextBidiParser;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDIconFit;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.pd.PDXObject;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class PushbuttonAppearanceStaticCreator
extends WidgetAppearanceStaticCreator {
    protected static final float SPACE = 5.0f;

    protected Rectangle2D calcRect(PDFont font, float fontSize, String text, Rectangle2D maxRect) {
        if (fontSize == 0.0f || font == null) {
            return null;
        }
        Rectangle2D rect = AppearanceTools.calcRect(font, fontSize, text);
        if (rect == null) {
            return rect;
        }
        if (rect.getWidth() > maxRect.getWidth()) {
            rect.setRect(rect.getX(), rect.getY(), maxRect.getWidth(), rect.getHeight());
        }
        if (rect.getHeight() > maxRect.getHeight()) {
            rect.setRect(rect.getX(), rect.getY(), rect.getWidth(), maxRect.getHeight());
        }
        return rect;
    }

    @Override
    protected void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        COSName behaviour = widget.getHighlightingMode();
        if (behaviour.equals(PDWidgetAnnotation.CN_H_N)) {
            this.createAppearanceNone(widget, appearance);
        }
        if (behaviour.equals(PDWidgetAnnotation.CN_H_I)) {
            this.createAppearanceInvert(widget, appearance);
        }
        if (behaviour.equals(PDWidgetAnnotation.CN_H_O)) {
            this.createAppearanceOutline(widget, appearance);
        }
        if (behaviour.equals(PDWidgetAnnotation.CN_H_P) || behaviour.equals(PDWidgetAnnotation.CN_H_T)) {
            this.createAppearancePush(widget, appearance);
        }
    }

    protected void createAppearanceInvert(PDWidgetAnnotation widget, PDAppearance appearance) {
        PDAppearanceCharacteristics apc = widget.getAppearanceCharacteristics();
        if (apc == null) {
            apc = PDAppearanceCharacteristics.META.createNew();
        }
        int layout = apc.getTextPosition();
        String normalCaption = apc.getNormalCaption();
        COSStream normalIcon = apc.cosGetNormalIcon();
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.createAppearanceStream(widget, normalForm, PDAnnotationTools.getBorderColor((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColor((PDWidgetAnnotation)widget), normalCaption, normalIcon, layout);
        String downCaption = apc.getDownCaption();
        COSStream downIcon = apc.cosGetDownIcon();
        if (downCaption == null && downIcon == null) {
            downCaption = normalCaption;
            downIcon = normalIcon;
        }
        PDForm downForm = PDAppearanceTools.getDownAppearance((PDAppearance)appearance, null);
        this.createAppearanceStream(widget, downForm, PDAnnotationTools.getBorderColorNegative((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColorNegative((PDWidgetAnnotation)widget), downCaption, downIcon, layout);
        appearance.setRolloverAppearance(null, null);
    }

    protected void createAppearanceNone(PDWidgetAnnotation widget, PDAppearance appearance) {
        PDAppearanceCharacteristics apc = widget.getAppearanceCharacteristics();
        if (apc == null) {
            apc = PDAppearanceCharacteristics.META.createNew();
        }
        int layout = apc.getTextPosition();
        String normalCaption = apc.getNormalCaption();
        COSStream normalIcon = apc.cosGetNormalIcon();
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.createAppearanceStream(widget, normalForm, PDAnnotationTools.getBorderColor((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColor((PDWidgetAnnotation)widget), normalCaption, normalIcon, layout);
        appearance.setDownAppearance(null, null);
        appearance.setRolloverAppearance(null, null);
    }

    protected void createAppearanceOutline(PDWidgetAnnotation widget, PDAppearance appearance) {
        PDAppearanceCharacteristics apc = widget.getAppearanceCharacteristics();
        if (apc == null) {
            apc = PDAppearanceCharacteristics.META.createNew();
        }
        int layout = apc.getTextPosition();
        String normalCaption = apc.getNormalCaption();
        COSStream normalIcon = apc.cosGetNormalIcon();
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.createAppearanceStream(widget, normalForm, PDAnnotationTools.getBorderColor((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColor((PDWidgetAnnotation)widget), normalCaption, normalIcon, layout);
        String downCaption = apc.getDownCaption();
        COSStream downIcon = apc.cosGetDownIcon();
        if (downCaption == null && downIcon == null) {
            downCaption = normalCaption;
            downIcon = normalIcon;
        }
        PDForm downForm = PDAppearanceTools.getDownAppearance((PDAppearance)appearance, null);
        this.createAppearanceStream(widget, downForm, PDAnnotationTools.getBorderColorNegative((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColor((PDWidgetAnnotation)widget), downCaption, downIcon, layout);
        appearance.setRolloverAppearance(null, null);
    }

    protected void createAppearancePush(PDWidgetAnnotation widget, PDAppearance appearance) {
        PDAppearanceCharacteristics apc = widget.getAppearanceCharacteristics();
        if (apc == null) {
            apc = PDAppearanceCharacteristics.META.createNew();
        }
        int layout = apc.getTextPosition();
        String normalCaption = apc.getNormalCaption();
        COSStream normalIcon = apc.cosGetNormalIcon();
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, null);
        this.createAppearanceStream(widget, normalForm, PDAnnotationTools.getBorderColor((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColor((PDWidgetAnnotation)widget), normalCaption, normalIcon, layout);
        String rolloverCaption = apc.getRolloverCaption();
        COSStream rolloverIcon = apc.cosGetRolloverIcon();
        if (rolloverCaption == null && rolloverIcon == null) {
            rolloverCaption = normalCaption;
            rolloverIcon = normalIcon;
        }
        PDForm rolloverForm = PDAppearanceTools.getRolloverAppearance((PDAppearance)appearance, null);
        this.createAppearanceStream(widget, rolloverForm, PDAnnotationTools.getBorderColor((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColor((PDWidgetAnnotation)widget), rolloverCaption, rolloverIcon, layout);
        String downCaption = apc.getDownCaption();
        COSStream downIcon = apc.cosGetDownIcon();
        if (downCaption == null && downIcon == null) {
            downCaption = normalCaption;
            downIcon = normalIcon;
        }
        PDForm downForm = PDAppearanceTools.getDownAppearance((PDAppearance)appearance, null);
        this.createAppearanceStream(widget, downForm, PDAnnotationTools.getBorderColorNegative((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColorNegative((PDWidgetAnnotation)widget), downCaption, downIcon, layout);
    }

    protected void createAppearanceStream(PDWidgetAnnotation annotation, PDForm form, float[] borderColor, float[] fillColor, String caption, COSStream icon, int layout) {
        this.initializeBoundingBox(form, (PDAnnotation)annotation);
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)form);
        float borderWidth = annotation.getBorderStyleWidth();
        COSName borderStyleName = annotation.getBorderStyleName();
        CDSRectangle boundingBox = form.getBoundingBox();
        this.drawWidgetRect(creator, boundingBox, borderColor, fillColor, borderWidth, borderStyleName);
        CDSRectangle contentRect = null;
        PDIconFit iconFit = null;
        PDAppearanceCharacteristics appChar = annotation.getAppearanceCharacteristics();
        if (appChar != null) {
            iconFit = appChar.getIconFit();
        }
        if (iconFit == null) {
            iconFit = (PDIconFit)PDIconFit.META.createNew();
        }
        contentRect = iconFit.isIgnoreBorderWidth() ? boundingBox.copy() : new CDSRectangle(boundingBox.getLowerLeftX() + borderWidth, boundingBox.getLowerLeftY() + borderWidth, boundingBox.getUpperRightX() - borderWidth, boundingBox.getUpperRightY() - borderWidth);
        this.drawContents(annotation, creator, contentRect, caption, icon, layout);
        creator.close();
    }

    protected void drawCaption(CSCreator creator, PDWidgetAnnotation annotation, CDSRectangle rect, String caption) {
        try {
            PDLTextPad pad = LayoutTools.createPad(annotation, rect);
            if (pad.getTextFormat().getFontSize() == 0.0f) {
                float fontsize = AppearanceTools.guessFontSize(pad, caption);
                fontsize = Math.max(6.0f, fontsize - 3.0f);
                pad.getTextFormat().setFontSize(fontsize);
            }
            PDLTextBidiParser parser = new PDLTextBidiParser();
            parser.setPad((IPDLTextPad)pad);
            parser.setMode(0);
            try {
                parser.parse((Reader)new StringReader(caption));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            PDAcroFormField formField = annotation.getAcroFormField();
            CSContent dac = formField.getDefaultAppearanceContent();
            if (dac != null) {
                creator.copy(dac);
            }
            pad.writeOn((ICSDevice)creator);
        }
        catch (PDLParseException e) {
            throw new COSRuntimeException((Throwable)e);
        }
    }

    protected void drawCaptionAndIcon(PDWidgetAnnotation annotation, CSCreator creator, CDSRectangle bounds, String caption, COSStream icon, int layout) {
        float fontSize = annotation.getAcroFormField().getDefaultAppearanceFontSize();
        PDFont font = annotation.getAcroFormField().getDefaultAppearanceFont();
        Rectangle2D prefTextRect = this.calcRect(font, fontSize, caption, bounds.toRectangle());
        CDSRectangle iconRect = null;
        CDSRectangle textRect = null;
        if (layout == 2 || layout == 3) {
            if (prefTextRect == null) {
                Rectangle2D maxTextRect = bounds.toNormalizedRectangle();
                maxTextRect.setRect(maxTextRect.getX(), maxTextRect.getY(), maxTextRect.getWidth(), maxTextRect.getHeight() / 3.0);
                fontSize = AppearanceTools.guessFontSize(maxTextRect, font, caption);
                prefTextRect = this.calcRect(font, fontSize, caption, bounds.toRectangle());
            }
            float textRectHeight = prefTextRect == null ? bounds.getHeight() / 3.0f : (float)prefTextRect.getHeight();
            float iconRectHeight = bounds.getHeight() - textRectHeight - 5.0f;
            if (layout == 2) {
                textRect = bounds.copy();
                textRect.setUpperRightY(textRect.getLowerLeftY() + textRectHeight);
                iconRect = bounds.copy();
                iconRect.setLowerLeftY(iconRect.getUpperRightY() - iconRectHeight);
            } else {
                textRect = bounds.copy();
                textRect.setLowerLeftY(textRect.getUpperRightY() - textRectHeight);
                iconRect = bounds.copy();
                iconRect.setUpperRightY(iconRect.getLowerLeftY() + iconRectHeight);
            }
        } else if (layout == 4 || layout == 5) {
            float diff;
            float textRectWidth = bounds.getWidth() / 2.0f - 2.5f;
            float iconRectWidth = bounds.getWidth() / 2.0f - 2.5f;
            if (prefTextRect != null && (diff = (float)(prefTextRect.getWidth() - (double)textRectWidth)) > 0.0f) {
                textRectWidth += diff;
                iconRectWidth -= diff;
            }
            if (layout == 4) {
                textRect = bounds.copy();
                textRect.setLowerLeftX(textRect.getUpperRightX() - textRectWidth);
                iconRect = bounds.copy();
                iconRect.setUpperRightX(iconRect.getLowerLeftX() + iconRectWidth);
            } else {
                textRect = bounds.copy();
                textRect.setUpperRightX(textRect.getLowerLeftX() + textRectWidth);
                iconRect = bounds.copy();
                iconRect.setLowerLeftX(iconRect.getUpperRightX() - iconRectWidth);
            }
        } else if (layout == 6) {
            textRect = bounds.copy();
            iconRect = bounds.copy();
        }
        if (textRect != null && iconRect != null) {
            this.drawIcon(creator, annotation, iconRect, icon);
            this.drawCaption(creator, annotation, textRect, caption);
        }
    }

    protected void drawContents(PDWidgetAnnotation annotation, CSCreator creator, CDSRectangle bounds, String caption, COSStream icon, int layout) {
        switch (layout) {
            case 0: {
                if (caption == null) break;
                this.drawCaption(creator, annotation, bounds, caption);
                break;
            }
            case 1: {
                if (icon == null) break;
                this.drawIcon(creator, annotation, bounds, icon);
                break;
            }
            default: {
                if (caption == null) {
                    if (icon == null) break;
                    this.drawIcon(creator, annotation, bounds, icon);
                    break;
                }
                if (icon == null) {
                    this.drawCaption(creator, annotation, bounds, caption);
                    break;
                }
                this.drawCaptionAndIcon(annotation, creator, bounds, caption, icon, layout);
            }
        }
    }

    protected void drawIcon(CSCreator creator, PDWidgetAnnotation annotation, CDSRectangle rect, COSStream iconStream) {
        PDAppearanceCharacteristics apc = annotation.getAppearanceCharacteristics();
        if (apc == null) {
            apc = PDAppearanceCharacteristics.META.createNew();
        }
        PDIconFit iconFit = apc.getIconFit();
        PDForm icon = (PDForm)PDForm.META.createFromCos((COSObject)iconStream);
        creator.saveState();
        CDSMatrix matrix = this.fit(icon, rect, iconFit);
        creator.transform(matrix.getA(), matrix.getB(), matrix.getC(), matrix.getD(), matrix.getE(), matrix.getF());
        creator.doXObject(null, (PDXObject)icon);
        creator.restoreState();
    }

    protected CDSMatrix fit(PDForm icon, CDSRectangle destRect, PDIconFit iconFit) {
        if (iconFit == null) {
            iconFit = (PDIconFit)PDIconFit.META.createNew();
        }
        float[] align = iconFit.getAlignment();
        COSName scaleMode = iconFit.getScalingMode();
        COSName scaleWhen = iconFit.getScalingCircumstances();
        float destWidth = destRect.getWidth();
        float destHeight = destRect.getHeight();
        float imageWidth = icon.getBoundingBox().getWidth();
        float imageHeight = icon.getBoundingBox().getHeight();
        float scaleX = destWidth / imageWidth;
        float scaleY = destHeight / imageHeight;
        if (scaleMode.equals((Object)PDIconFit.CN_S_P)) {
            scaleY = scaleX = Math.min(scaleX, scaleY);
        }
        if (!scaleWhen.equals((Object)PDIconFit.CN_SW_A)) {
            if (scaleWhen.equals((Object)PDIconFit.CN_SW_N)) {
                scaleX = 1.0f;
                scaleY = 1.0f;
            } else if (scaleWhen.equals((Object)PDIconFit.CN_SW_B)) {
                if (scaleX > 1.0f && scaleY > 1.0f) {
                    scaleX = 1.0f;
                    scaleY = 1.0f;
                }
            } else if (scaleWhen.equals((Object)PDIconFit.CN_SW_S) && scaleX <= 1.0f && scaleY <= 1.0f) {
                scaleX = 1.0f;
                scaleY = 1.0f;
            }
        }
        float scaledWidth = imageWidth * scaleX;
        float scaledHeight = imageHeight * scaleY;
        float alignX = align[0];
        float alignY = align[1];
        double offsetX = Math.max(0.0f, destWidth - scaledWidth) * alignX;
        double offsetY = Math.max(0.0f, destHeight - scaledHeight) * alignY;
        CDSMatrix matrix = new CDSMatrix();
        matrix.translate(destRect.getLowerLeftX(), destRect.getLowerLeftY());
        matrix.translate((float)offsetX, (float)offsetY);
        matrix.scale(new float[]{scaleX, scaleY});
        CDSMatrix iconMatrix = icon.getMatrix();
        if (iconMatrix != null) {
            matrix.translate(-iconMatrix.getE(), -iconMatrix.getF());
        }
        return matrix;
    }

    protected String getDownCaption(PDWidgetAnnotation widget) {
        return widget.getAppearanceCharacteristics().getNormalCaption();
    }

    protected String getNormalCaption(PDWidgetAnnotation widget) {
        return widget.getAppearanceCharacteristics().getNormalCaption();
    }

    protected String getRolloverCaption(PDWidgetAnnotation widget) {
        return widget.getAppearanceCharacteristics().getNormalCaption();
    }
}

