/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.widget;

import de.intarsys.pdf.app.appearance.widget.StatefulAppearanceStaticCreator;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDWidgetAnnotation;

public class RadioAppearanceStaticCreator
extends StatefulAppearanceStaticCreator {
    public static final String CAPTION_CHECK = "4";
    public static final String CAPTION_CIRCLE = "l";
    public static final String CAPTION_CROSS = "8";
    public static final String CAPTION_DIAMOND = "u";
    public static final String CAPTION_SQUARE = "n";
    public static final String CAPTION_STAR = "H";

    @Override
    public void createAppearance(PDAnnotation annotation, COSName state, PDAppearance appearance) {
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDForm normalForm = PDAppearanceTools.getNormalAppearance((PDAppearance)appearance, (COSName)state);
        this.createAppearanceStream(widget, normalForm, PDAnnotationTools.getBorderColor((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColor((PDWidgetAnnotation)widget), PDAnnotationTools.isStateChecked((COSName)state));
        PDForm downForm = PDAppearanceTools.getDownAppearance((PDAppearance)appearance, (COSName)state);
        this.createAppearanceStream(widget, downForm, PDAnnotationTools.getBorderColorNegative((PDWidgetAnnotation)widget), PDAnnotationTools.getFillColorNegative((PDWidgetAnnotation)widget), PDAnnotationTools.isStateChecked((COSName)state));
    }

    protected void createAppearanceStream(PDWidgetAnnotation annotation, PDForm form, float[] borderColor, float[] fillColor, boolean checked) {
        this.initializeBoundingBox(form, (PDAnnotation)annotation);
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)form);
        float borderWidth = annotation.getBorderStyleWidth();
        COSName borderStyleName = annotation.getBorderStyleName();
        PDAppearanceCharacteristics apc = annotation.getAppearanceCharacteristics();
        if (apc == null) {
            apc = PDAppearanceCharacteristics.META.createNew();
        }
        String captionString = apc.getNormalCaption();
        CDSRectangle boundingBox = form.getBoundingBox();
        if (captionString == null || captionString.equals(CAPTION_CIRCLE)) {
            if (borderColor == null) {
                borderColor = new float[]{0.5f, 0.5f, 0.5f};
            }
            if (borderWidth == 0.0f) {
                borderWidth = 0.5f;
            }
            this.drawWidgetCircle(creator, boundingBox, borderColor, fillColor, borderWidth, borderStyleName);
        } else {
            this.drawWidgetRect(creator, boundingBox, borderColor, fillColor, borderWidth, borderStyleName);
        }
        if (checked) {
            CDSRectangle textRect = new CDSRectangle(boundingBox.getLowerLeftX() + borderWidth, boundingBox.getLowerLeftY() + borderWidth, boundingBox.getUpperRightX() - borderWidth, boundingBox.getUpperRightY() - borderWidth);
            if (captionString == null || captionString.equals(CAPTION_CIRCLE)) {
                this.drawWidgetCircleCheckmark(creator, annotation, textRect);
            } else if (CAPTION_CROSS.equals(captionString)) {
                this.drawWidgetCrossCheckmark(creator, annotation, textRect);
            } else {
                this.drawWidgetCheckmark(creator, annotation, textRect, this.getNormalCaption(annotation));
            }
        }
        creator.close();
    }

    protected void drawWidgetCircle(CSCreator creator, CDSRectangle rect, float[] borderColor, float[] fillColor, float borderWidth, COSName borderStyleName) {
        float centerX = rect.getLowerLeftX() + rect.getWidth() / 2.0f;
        float centerY = rect.getLowerLeftY() + rect.getHeight() / 2.0f;
        float r = Math.min(rect.getWidth(), rect.getHeight()) / 2.0f;
        if (fillColor != null) {
            CSDeviceTools.setNonStrokeColor((ICSDevice)creator, (float[])fillColor);
            creator.penCircle(centerX, centerY, r);
            creator.pathFillNonZero();
        }
        if (borderColor != null && borderWidth != 0.0f) {
            creator.setLineWidth(borderWidth);
            CSDeviceTools.setStrokeColor((ICSDevice)creator, (float[])borderColor);
            creator.penCircle(centerX, centerY, r - 0.5f * borderWidth);
            creator.pathCloseStroke();
        }
    }

    protected void drawWidgetCircleCheckmark(CSCreator creator, PDWidgetAnnotation annotation, CDSRectangle rect) {
        float centerX = rect.getLowerLeftX() + rect.getWidth() / 2.0f;
        float centerY = rect.getLowerLeftY() + rect.getHeight() / 2.0f;
        float r = Math.min(rect.getWidth(), rect.getHeight()) * 0.3f;
        CSDeviceTools.setNonStrokeColor((ICSDevice)creator, (float[])this.getFontColor(annotation));
        creator.penCircle(centerX, centerY, r);
        creator.pathFillNonZero();
    }

    protected void drawWidgetCrossCheckmark(CSCreator creator, PDWidgetAnnotation annotation, CDSRectangle rect) {
        float width = 2.0f;
        float distFactor = 0.1f;
        creator.setLineWidth(width);
        CSDeviceTools.setStrokeColor((ICSDevice)creator, (float[])this.getFontColor(annotation));
        creator.penMoveTo(rect.getLowerLeftX() + distFactor * rect.getWidth(), rect.getLowerLeftY() + distFactor * rect.getHeight());
        creator.penLineTo(rect.getUpperRightX() - distFactor * rect.getWidth(), rect.getUpperRightY() - distFactor * rect.getHeight());
        creator.pathStroke();
        creator.penMoveTo(rect.getLowerLeftX() + distFactor * rect.getWidth(), rect.getUpperRightY() - distFactor * rect.getHeight());
        creator.penLineTo(rect.getUpperRightX() - distFactor * rect.getWidth(), rect.getLowerLeftY() + distFactor * rect.getHeight());
        creator.pathStroke();
    }

    protected String getNormalCaption(PDWidgetAnnotation annotation) {
        String caption = annotation.getAppearanceCharacteristics().getNormalCaption();
        if (caption == null) {
            caption = CAPTION_CIRCLE;
        }
        return caption;
    }
}

