/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.widget;

import de.intarsys.pdf.app.appearance.widget.WidgetAppearanceStaticCreator;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.Set;

public abstract class StatefulAppearanceStaticCreator
extends WidgetAppearanceStaticCreator {
    protected StatefulAppearanceStaticCreator() {
    }

    protected abstract void createAppearance(PDAnnotation var1, COSName var2, PDAppearance var3);

    @Override
    protected void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        Set states = annotation.getAppearanceStates();
        states.add(COSName.create((String)"Off"));
        for (COSName state : states) {
            this.createAppearance(annotation, state, appearance);
        }
    }

    protected void drawWidgetCheckmark(CSCreator creator, PDWidgetAnnotation annotation, CDSRectangle rect, String caption) {
        CSContent dac;
        creator.saveState();
        creator.penRectangle(rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getWidth(), rect.getHeight());
        creator.pathClipNonZero();
        creator.pathEnd();
        PDFont font = PDFontTools.createBuiltinFont((String)"ZapfDingbats");
        PDAcroFormField formField = annotation.getAcroFormField();
        float fontsize = formField.getDefaultAppearanceFontSize();
        if (fontsize == 0.0f) {
            fontsize = Math.min(rect.getWidth(), rect.getHeight()) * 0.8f;
        }
        if ((dac = formField.getDefaultAppearanceContent()) != null) {
            creator.copy(dac);
            if (font != null) {
                COSName fontName = formField.getDefaultAppearanceFontName();
                creator.getResourcesProvider().getResources().addFontResource(fontName, font);
            }
        }
        creator.textBegin();
        byte[] bytes = caption.getBytes();
        float captionWidth = PDFontTools.getGlyphWidthEncodedScaled((PDFont)font, (float)fontsize, (byte[])bytes, (int)0, (int)bytes.length);
        float captionHeight = PDFontTools.getGlyphHeightScaled((PDFont)font, (float)fontsize);
        captionHeight = 0.7f * captionHeight;
        creator.textSetFont(null, font, fontsize);
        creator.textLineMoveTo(rect.getLowerLeftX() + (rect.getWidth() - captionWidth) / 2.0f, rect.getLowerLeftY() + (rect.getHeight() - captionHeight) / 2.0f);
        creator.textShow(caption);
        creator.textEnd();
        creator.restoreState();
    }
}

