/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.widget;

import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.app.appearance.common.CommonWidgetAppearanceCreator;
import de.intarsys.pdf.app.appearance.widget.CheckboxAppearanceStaticCreator;
import de.intarsys.pdf.app.appearance.widget.ComboAppearanceStaticCreator;
import de.intarsys.pdf.app.appearance.widget.ComboAppearanceValueCreator;
import de.intarsys.pdf.app.appearance.widget.ListAppearanceStaticCreator;
import de.intarsys.pdf.app.appearance.widget.ListAppearanceValueCreator;
import de.intarsys.pdf.app.appearance.widget.PushbuttonAppearanceStaticCreator;
import de.intarsys.pdf.app.appearance.widget.RadioAppearanceStaticCreator;
import de.intarsys.pdf.app.appearance.widget.SignatureAppearanceStaticCreator;
import de.intarsys.pdf.app.appearance.widget.TextAppearanceStaticCreator;
import de.intarsys.pdf.app.appearance.widget.TextAppearanceValueCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAFButtonField;
import de.intarsys.pdf.pd.PDAFChoiceField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDWidgetAnnotation;

public class WidgetAppearanceCreator
extends CommonWidgetAppearanceCreator {
    private IAppearanceCreator textCreator = new TextAppearanceStaticCreator();
    private IAppearanceCreator radioCreator = new RadioAppearanceStaticCreator();
    private IAppearanceCreator pushbuttonCreator = new PushbuttonAppearanceStaticCreator();
    private IAppearanceCreator listCreator = new ListAppearanceStaticCreator();
    private IAppearanceCreator comboCreator = new ComboAppearanceStaticCreator();
    private IAppearanceCreator checkboxCreator = new CheckboxAppearanceStaticCreator();
    private IAppearanceCreator signatureCreator = new SignatureAppearanceStaticCreator();
    private IAppearanceCreator comboValueCreator = new ComboAppearanceValueCreator();
    private IAppearanceCreator listValueCreator = new ListAppearanceValueCreator();
    private IAppearanceCreator textValueCreator = new TextAppearanceValueCreator();

    @Override
    public void createAppearanceForms(PDAnnotation annotation, PDAppearance appearance) {
        if (!annotation.isWidgetAnnotation()) {
            return;
        }
        PDAcroFormField field = ((PDWidgetAnnotation)annotation).getAcroFormField();
        if (field.isTypeBtn()) {
            PDAFButtonField button = (PDAFButtonField)field;
            if (button.isPushbutton()) {
                this.pushbuttonCreator.createAppearance(annotation, appearance);
            } else if (button.isRadio()) {
                this.radioCreator.createAppearance(annotation, appearance);
            } else if (button.isCheckbox()) {
                this.checkboxCreator.createAppearance(annotation, appearance);
            }
        } else if (field.isTypeCh()) {
            PDAFChoiceField choice = (PDAFChoiceField)field;
            if (choice.isCombo()) {
                this.comboCreator.createAppearance(annotation, appearance);
                this.comboValueCreator.createAppearance(annotation, appearance);
            } else {
                this.listCreator.createAppearance(annotation, appearance);
                this.listValueCreator.createAppearance(annotation, appearance);
            }
        } else if (field.isTypeTx()) {
            this.textCreator.createAppearance(annotation, appearance);
            this.textValueCreator.createAppearance(annotation, appearance);
        } else if (field.isTypeSig()) {
            this.signatureCreator.createAppearance(annotation, appearance);
        }
    }

    public COSName getAnnotationType() {
        return PDWidgetAnnotation.CN_Subtype_Widget;
    }
}

