/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.widget;

import de.intarsys.pdf.app.appearance.common.CommonWidgetAppearanceCreator;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDBorderStyle;

public abstract class WidgetAppearanceStaticCreator
extends CommonWidgetAppearanceCreator {
    protected void drawWidgetRect(CSCreator creator, CDSRectangle rect, float[] borderColor, float[] fillColor, float borderWidth, COSName borderStyle) {
        creator.saveState();
        if (fillColor != null) {
            CSDeviceTools.setNonStrokeColor((ICSDevice)creator, (float[])fillColor);
            creator.penRectangle(rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getWidth(), rect.getHeight());
            creator.pathFillNonZero();
        }
        if (borderColor != null && borderWidth != 0.0f) {
            creator.setLineWidth(borderWidth);
            CSDeviceTools.setStrokeColor((ICSDevice)creator, (float[])borderColor);
            if (PDBorderStyle.CN_S_U.equals((Object)borderStyle)) {
                creator.penMoveTo(rect.getLowerLeftX() + 0.5f * borderWidth, rect.getLowerLeftY() + 0.5f * borderWidth);
                creator.penLineTo(rect.getLowerLeftX() + rect.getWidth() - 0.5f * borderWidth, rect.getLowerLeftY() + 0.5f * borderWidth);
            } else {
                creator.penRectangle(rect.getLowerLeftX() + 0.5f * borderWidth, rect.getLowerLeftY() + 0.5f * borderWidth, rect.getWidth() - borderWidth, rect.getHeight() - borderWidth);
            }
            creator.pathCloseStroke();
        }
        creator.restoreState();
    }

    public COSName getAnnotationType() {
        return null;
    }
}

