/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance.widget;

import de.intarsys.layout.CBorderPolicy;
import de.intarsys.pdf.app.action.ActionTools;
import de.intarsys.pdf.app.action.TriggerEvent;
import de.intarsys.pdf.app.appearance.common.AppearanceTools;
import de.intarsys.pdf.app.appearance.common.CommonWidgetAppearanceCreator;
import de.intarsys.pdf.app.appearance.widget.LayoutTools;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.outlet.FontOutlet;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.layout.html.parser.PDLTextHtmlParser;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLTextPad;
import de.intarsys.pdf.layout.parser.IPDLCreationHandler;
import de.intarsys.pdf.layout.parser.PDLAbstractDocumentParser;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.layout.parser.PDLStopParse;
import de.intarsys.pdf.layout.parser.PDLTextBidiParser;
import de.intarsys.pdf.pd.IResourcesProvider;
import de.intarsys.pdf.pd.PDAFChoiceField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.tools.component.IStartStop;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;

public abstract class WidgetAppearanceValueCreator
extends CommonWidgetAppearanceCreator {
    public static final Object ATTR_HTML = new Object();
    public static final Object ATTR_FORMATTED_VALUE = new Object();

    protected boolean canFitAppearance(String formattedValue, PDWidgetAnnotation widget, float fontsize) {
        PDAcroFormField field = widget.getAcroFormField();
        PDLTextPad pad = this.createPad(widget, fontsize);
        pad.getTextFormat().setFontSize(fontsize);
        PDLAbstractDocumentParser parser = this.createParser(field, (IPDLTextPad)pad);
        pad.getLayouter().setPrimaryBorderPolicy(CBorderPolicy.FIX);
        pad.getLayouter().setSecondaryBorderPolicy(CBorderPolicy.FIX);
        final boolean[] fit = new boolean[]{true};
        parser.setCreationHandler(new IPDLCreationHandler(){

            public void handleEnd(PDLAbstractDocumentParser parser) throws PDLParseException {
            }

            public boolean handleOverflow(PDLAbstractDocumentParser parser, List overflow) throws PDLParseException {
                fit[0] = false;
                return false;
            }
        });
        this.parseString(field, formattedValue, parser);
        return fit[0];
    }

    protected void createAppearanceString(PDWidgetAnnotation widget, PDAppearance appearance, String value) {
        PDAcroFormField field = widget.getAcroFormField();
        String formattedValue = this.getFormattedValue(field, value);
        float fontSize = field.getDefaultAppearanceFontSize();
        if (fontSize == 0.0f) {
            fontSize = field.isMultiline() ? this.guessFontSizeMultiline(widget, formattedValue) : this.guessFontSizeSingleline(widget, formattedValue);
        }
        this.createAppearanceStringFix(widget, appearance, field, formattedValue, fontSize);
    }

    protected PDForm createAppearanceStringFix(PDWidgetAnnotation widget, PDAppearance appearance, PDAcroFormField field, String formattedValue, float fontSize) {
        PDLTextPad pad = this.createPad(widget, fontSize);
        PDLAbstractDocumentParser parser = this.createParser(field, (IPDLTextPad)pad);
        this.parseString(field, formattedValue, parser);
        return this.createAppearanceStringReady(widget, appearance, pad, 1.0f, 0.0f);
    }

    protected PDForm createAppearanceStringReady(PDWidgetAnnotation widget, PDAppearance appearance, PDLTextPad pad, float scale, float dy) {
        PDForm form = this.createNormalAppearance((PDAnnotation)widget, appearance);
        CSContent content = CSContent.createNew();
        CSCreator creator = CSCreator.createFromContent((CSContent)content, (IResourcesProvider)form);
        creator.saveState();
        creator.textBegin();
        PDAcroFormField field = widget.getAcroFormField();
        CSContent da = field.getDefaultAppearanceContent();
        if (da != null) {
            creator.copy(da);
        }
        COSName fontName = field.getDefaultAppearanceFontName();
        PDResources resources = form.getResources();
        if (fontName != null && resources.getFontResource(fontName) == null) {
            PDFont font = field.getDefaultAppearanceFont();
            resources.addFontResource(fontName, font);
        }
        if (scale != 1.0f || dy != 0.0f) {
            creator.transform(scale, 0.0f, 0.0f, scale, 0.0f, dy);
        }
        pad.writeOn((ICSDevice)creator);
        creator.textEnd();
        creator.restoreState();
        creator.close();
        form.setMarkedContent(creator.getContent().toByteArray());
        return form;
    }

    protected PDLTextPad createPad(PDWidgetAnnotation widget) {
        float fontSize = widget.getAcroFormField().getDefaultAppearanceFontSize();
        return this.createPad(widget, fontSize);
    }

    protected PDLTextPad createPad(PDWidgetAnnotation widget, float fontSize) {
        return LayoutTools.createPad(widget, fontSize);
    }

    protected PDLAbstractDocumentParser createParser(PDAcroFormField field, IPDLTextPad pad) {
        if (this.isHTMLContent(field)) {
            return this.createParserHTML(field, pad);
        }
        return this.createParserPlain(field, pad);
    }

    protected PDLAbstractDocumentParser createParserHTML(PDAcroFormField field, IPDLTextPad pad) {
        IFontFactory factory = FontOutlet.get().lookupFontFactory(field.getAcroForm().getDoc());
        PDLTextHtmlParser parser = new PDLTextHtmlParser(factory);
        parser.setMode(1);
        parser.setPad(pad);
        return parser;
    }

    protected PDLAbstractDocumentParser createParserPlain(PDAcroFormField field, IPDLTextPad pad) {
        PDLTextBidiParser parser = new PDLTextBidiParser();
        if (field.isMultiline()) {
            parser.setMode(1);
        } else {
            parser.setMode(0);
        }
        parser.setPad(pad);
        return parser;
    }

    public COSName getAnnotationType() {
        return null;
    }

    protected String getFormattedValue(PDAcroFormField field, String value) {
        PDAcroFormField root = field.getLogicalRoot();
        String formattedValue = (String)root.getAttribute(ATTR_FORMATTED_VALUE);
        if (formattedValue == null) {
            TriggerEvent trigger = this.triggerFormat(field, true, 0, value);
            formattedValue = trigger.getValueString();
            if (formattedValue == null) {
                formattedValue = "";
            }
            root.setAttribute(ATTR_FORMATTED_VALUE, (Object)formattedValue);
            FormatInvalidator invalidator = (FormatInvalidator)root.getAttribute(FormatInvalidator.class);
            if (invalidator == null) {
                invalidator = new FormatInvalidator(root);
                invalidator.start();
            } else {
                invalidator.setField(root);
            }
        }
        return formattedValue;
    }

    protected float guessFontSizeMultiline(PDWidgetAnnotation widget, String formattedValue) {
        float fontSize;
        for (fontSize = Math.min(12.0f, this.guessFontSizeSingleline(widget, "X")); fontSize > 1.0f && !this.canFitAppearance(formattedValue, widget, fontSize); fontSize -= 1.0f) {
        }
        return fontSize;
    }

    protected float guessFontSizeSingleline(PDWidgetAnnotation widget, String formattedValue) {
        PDLTextPad pad = this.createPad(widget);
        Rectangle2D originalBbox = pad.getLayouter().getBoundingBox().getBounds2D();
        return AppearanceTools.guessFontSize(pad, formattedValue);
    }

    protected boolean isHTMLContent(PDAcroFormField field) {
        return Boolean.TRUE.equals(field.getAttribute(ATTR_HTML));
    }

    protected void parseString(PDAcroFormField field, String formattedValue, PDLAbstractDocumentParser parser) {
        try {
            StringReader reader = new StringReader(formattedValue);
            parser.parse((Reader)reader);
        }
        catch (IOException e) {
            throw new COSRuntimeException((Throwable)e);
        }
        catch (PDLStopParse e) {
        }
        catch (PDLParseException e) {
            throw new COSRuntimeException((Throwable)e);
        }
    }

    protected TriggerEvent triggerFormat(PDAcroFormField field, boolean willCommit, int commitKey, String value) {
        return ActionTools.fieldTriggerFormat((PDAcroFormField)field, (boolean)willCommit, (int)commitKey, (String)value);
    }

    public class FormatInvalidator
    implements IStartStop {
        private PDAcroFormField field;
        private ICOSObjectListener listenValue = new ICOSObjectListener(){

            public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
                if (PDAcroFormField.DK_V.equals(slot)) {
                    FormatInvalidator.this.invalidate();
                }
                if (PDAFChoiceField.DK_Opt.equals(slot)) {
                    FormatInvalidator.this.invalidate();
                }
            }
        };
        private ICOSObjectListener listenActions = new ICOSObjectListener(){

            public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
                if (PDAcroFormField.DK_AA.equals(slot)) {
                    FormatInvalidator.this.invalidate();
                }
            }
        };
        private ICOSObjectListener listenFormatAction = new ICOSObjectListener(){

            public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
                if (PDAdditionalActions.CN_trigger_F.equals(slot)) {
                    FormatInvalidator.this.invalidate();
                }
            }
        };

        public FormatInvalidator(PDAcroFormField field) {
            this.field = field;
        }

        protected void addActionsListeners(COSDictionary actions) {
            actions.addObjectListener(this.listenFormatAction);
        }

        protected void addFieldListeners(COSDictionary field) {
            field.addObjectListener(this.listenValue);
            field.addObjectListener(this.listenActions);
            COSDictionary actions = field.get(PDAcroFormField.DK_AA).asDictionary();
            if (actions != null) {
                this.addActionsListeners(actions);
            }
        }

        protected void invalidate() {
            this.field.removeAttribute(ATTR_FORMATTED_VALUE);
            this.stop();
        }

        public boolean isStarted() {
            return false;
        }

        protected void removeActionsListeners(COSDictionary actions) {
            actions.removeObjectListener(this.listenFormatAction);
        }

        protected void removeFieldListeners(COSDictionary field) {
            field.removeObjectListener(this.listenValue);
            field.removeObjectListener(this.listenActions);
            COSDictionary actions = field.get(PDAcroFormField.DK_AA).asDictionary();
            if (actions != null) {
                this.removeActionsListeners(actions);
            }
        }

        public void setField(PDAcroFormField field) {
            this.stop();
            this.field = field;
            this.start();
        }

        public void start() {
            this.addFieldListeners(this.field.cosGetDict());
        }

        public void stop() {
            this.removeFieldListeners(this.field.cosGetDict());
        }

        public boolean stopRequested(Set visited) {
            return true;
        }
    }
}

