/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.colorspace;

import de.intarsys.pdf.app.common.IntarsysApplicationData;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectWalkerDeep;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDApplicationData;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class ColorSpaceCache {
    public static ISearchStrategy STRATEGY_DOCUMENT = new CommonSearchStrategy(){

        @Override
        protected void basicSearchProfile(PDDocument doc, ICOSObjectVisitor walker) {
            try {
                doc.cosGetDoc().stGetDoc().cosGetTrailer().accept(walker);
            }
            catch (COSVisitorException cOSVisitorException) {
                // empty catch block
            }
        }
    };
    public static ISearchStrategy STRATEGY_FORM = new CommonSearchStrategy(){

        @Override
        protected void basicSearchProfile(PDDocument doc, ICOSObjectVisitor walker) {
            PDAcroForm form = doc.getAcroForm();
            if (form != null) {
                try {
                    form.cosGetObject().accept(walker);
                }
                catch (COSVisitorException cOSVisitorException) {
                    // empty catch block
                }
            }
        }
    };
    public static ISearchStrategy STRATEGY_SIGNATURES = new CommonSearchStrategy(){

        @Override
        protected void basicSearchProfile(PDDocument doc, ICOSObjectVisitor walker) {
            PDAcroForm form = doc.getAcroForm();
            if (form != null) {
                for (PDAcroFormField field : form.collectLeafFields()) {
                    if (!field.isTypeSig()) continue;
                    try {
                        field.cosGetObject().accept(walker);
                    }
                    catch (COSVisitorException cOSVisitorException) {}
                }
            }
        }
    };
    public static COSName DK_Gray_ICC = COSName.constant((String)"Gray_ICC");
    public static COSName DK_RGB_ICC = COSName.constant((String)"RGB_ICC");
    public static COSName DK_CMYK_ICC = COSName.constant((String)"CMYK_ICC");
    public static final COSName CN_colorspaces = COSName.constant((String)"colorspaces");
    private ISearchStrategy searchStrategy;
    private final PDDocument doc;
    private final COSDictionary colorSpaceCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static COSStream basicLoadICCStream(String resourceName, int numComponents) {
        InputStream is = ColorSpaceCache.class.getResourceAsStream(resourceName);
        try {
            COSStream cOSStream = ColorSpaceCache.createCSStream(is, numComponents);
            return cOSStream;
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    protected static COSStream createCSStream(InputStream is, int numComponents) {
        if (is == null) {
            return null;
        }
        try {
            byte[] bytes = null;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamTools.copy((InputStream)is, (OutputStream)bos);
            StreamTools.close((Closeable)bos);
            bytes = bos.toByteArray();
            COSStream profile = COSStream.create(null);
            profile.setEncodedBytes(bytes);
            profile.addFilter(Filter.CN_Filter_FlateDecode);
            profile.getDict().put(PDCSICCBased.DK_N, (COSObject)COSInteger.create((int)numComponents));
            return profile;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ColorSpaceCache get(PDDocument doc) {
        ColorSpaceCache result = (ColorSpaceCache)doc.getAttribute(ColorSpaceCache.class);
        if (result == null) {
            COSDictionary cosColorspaces;
            PDApplicationData applicationData = IntarsysApplicationData.get(doc);
            if (applicationData != null && (cosColorspaces = applicationData.cosGetField(CN_colorspaces).asDictionary()) != null) {
                result = new ColorSpaceCache(doc, cosColorspaces);
            }
            if (result == null) {
                result = new ColorSpaceCache(doc, COSDictionary.create());
            }
            result.setSearchStrategy(STRATEGY_SIGNATURES);
            doc.setAttribute(ColorSpaceCache.class, (Object)result);
        }
        return result;
    }

    public static COSStream loadCmykIccStream() {
        return ColorSpaceCache.basicLoadICCStream("ISOcoated_v2_eci.icc", 4);
    }

    public static COSStream loadGrayIccStream() {
        return ColorSpaceCache.basicLoadICCStream("adb_Gray.icc", 1);
    }

    public static COSStream loadRgbIccStream() {
        return ColorSpaceCache.basicLoadICCStream("sRGB_IEC61966-2-1_noBPC.icc", 3);
    }

    protected ColorSpaceCache(PDDocument doc, COSDictionary cosObject) {
        this.doc = doc;
        this.colorSpaceCache = cosObject;
    }

    public COSDictionary getColorSpaceCache() {
        return this.colorSpaceCache;
    }

    public PDColorSpace getColorSpaceCmykIcc() {
        COSStream profile = this.getColorSpaceCache().get(DK_CMYK_ICC).asStream();
        if (profile == null || profile.isStale()) {
            profile = ColorSpaceCache.loadCmykIccStream();
            profile = this.searchDocument(profile);
            this.getColorSpaceCache().put(DK_CMYK_ICC, (COSObject)profile);
        }
        if (profile == null) {
            return null;
        }
        COSArray csarray = COSArray.create((int)2);
        csarray.add((COSObject)PDColorSpace.CN_CS_ICCBased);
        csarray.add((COSObject)profile);
        return (PDColorSpace)PDColorSpace.META.createFromCos((COSObject)csarray);
    }

    public PDColorSpace getColorSpaceGrayIcc() {
        COSStream profile = this.getColorSpaceCache().get(DK_Gray_ICC).asStream();
        if (profile == null || profile.isStale()) {
            profile = ColorSpaceCache.loadGrayIccStream();
            profile = this.searchDocument(profile);
            this.getColorSpaceCache().put(DK_Gray_ICC, (COSObject)profile);
        }
        if (profile == null) {
            return null;
        }
        COSArray csarray = COSArray.create((int)2);
        csarray.add((COSObject)PDColorSpace.CN_CS_ICCBased);
        csarray.add((COSObject)profile);
        return (PDColorSpace)PDColorSpace.META.createFromCos((COSObject)csarray);
    }

    public PDColorSpace getColorSpaceRgbIcc() {
        COSStream profile = this.getColorSpaceCache().get(DK_RGB_ICC).asStream();
        if (profile == null || profile.isStale()) {
            profile = ColorSpaceCache.loadRgbIccStream();
            profile = this.searchDocument(profile);
            this.getColorSpaceCache().put(DK_RGB_ICC, (COSObject)profile);
        }
        if (profile == null) {
            return null;
        }
        COSArray csarray = COSArray.create((int)2);
        csarray.add((COSObject)PDColorSpace.CN_CS_ICCBased);
        csarray.add((COSObject)profile);
        return (PDColorSpace)PDColorSpace.META.createFromCos((COSObject)csarray);
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public ISearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }

    public void persist() {
        PDApplicationData applicationData = IntarsysApplicationData.get(this.getDoc());
        if (applicationData == null) {
            applicationData = (PDApplicationData)PDApplicationData.META.createNew();
            IntarsysApplicationData.set(applicationData, this.doc);
        }
        applicationData.cosSetField(CN_colorspaces, (COSObject)this.getColorSpaceCache());
    }

    protected COSStream searchDocument(COSStream profile) {
        if (profile == null || this.getDoc() == null || this.getSearchStrategy() == null) {
            return null;
        }
        int numComponents = profile.getDict().get(PDCSICCBased.DK_N).asInteger().intValue();
        byte[] bytes = profile.getDecodedBytes();
        COSStream tempStream = this.getSearchStrategy().searchProfile(this.getDoc(), numComponents, bytes);
        return tempStream == null ? profile : tempStream;
    }

    public void setSearchStrategy(ISearchStrategy searchStrategy) {
        this.searchStrategy = searchStrategy;
    }

    public static interface ISearchStrategy {
        public COSStream searchProfile(PDDocument var1, int var2, byte[] var3);
    }

    public static abstract class CommonSearchStrategy
    implements ISearchStrategy {
        protected abstract void basicSearchProfile(PDDocument var1, ICOSObjectVisitor var2);

        protected boolean checkProfile(COSStream profile, int numComponents, byte[] bytes) {
            if (profile == null) {
                return false;
            }
            if (!profile.isIndirect()) {
                return false;
            }
            COSInteger profileComponents = profile.getDict().get(PDCSICCBased.DK_N).asInteger();
            if (profileComponents == null || profileComponents.intValue() != numComponents) {
                return false;
            }
            return Arrays.equals(profile.getDecodedBytes(), bytes);
        }

        @Override
        public COSStream searchProfile(PDDocument doc, final int numComponents, final byte[] bytes) {
            final COSStream[] result = new COSStream[1];
            COSObjectWalkerDeep walker = new COSObjectWalkerDeep(){

                public Object visitFromArray(COSArray array) throws COSVisitorException {
                    if (result[0] != null) {
                        return null;
                    }
                    return super.visitFromArray(array);
                }

                protected boolean visitFromArrayBefore(COSArray array) {
                    COSStream profileStream;
                    COSObject type;
                    if (array.size() > 1 && PDColorSpace.CN_CS_ICCBased.equals((Object)(type = array.get(0))) && this.checkProfile(profileStream = array.get(1).asStream(), numComponents, bytes)) {
                        result[0] = profileStream;
                        return false;
                    }
                    return true;
                }

                public Object visitFromDictionary(COSDictionary dict) throws COSVisitorException {
                    if (result[0] != null) {
                        return null;
                    }
                    return super.visitFromDictionary(dict);
                }

                public Object visitFromIndirectObject(COSIndirectObject io) throws COSVisitorException {
                    if (result[0] != null) {
                        return null;
                    }
                    return super.visitFromIndirectObject(io);
                }
            };
            this.basicSearchProfile(doc, (ICOSObjectVisitor)walker);
            return result[0];
        }
    }
}

