/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.colorspace;

import de.intarsys.pdf.app.colorspace.ColorSpaceCache;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSInterpreter;
import de.intarsys.pdf.content.CSInterpreterFrame;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.AnnotationFlags;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDXObject;
import java.util.List;

public class ColorSpaceImporter {
    private PDDocument pdDoc;

    public ColorSpaceImporter(PDDocument context) {
        this.pdDoc = context;
    }

    protected void basicProcess(PDXObject xobject) {
        COSObject cosColorSpace = xobject.cosGetField(PDImage.DK_ColorSpace);
        if (cosColorSpace.isNull()) {
            return;
        }
        PDColorSpace colorSpace = (PDColorSpace)PDColorSpace.META.createFromCos(cosColorSpace);
        PDColorSpace fixed = this.fixColorSpace(colorSpace);
        if (fixed != null) {
            xobject.cosSetField(PDImage.DK_ColorSpace, fixed.cosGetObject());
        }
    }

    protected PDColorSpace fixColorSpace(PDColorSpace colorSpace) {
        if (colorSpace == null) {
            colorSpace = PDCSDeviceRGB.SINGLETON;
        }
        if (colorSpace.cosGetObject() instanceof COSArray) {
            return null;
        }
        if (colorSpace == PDCSDeviceGray.SINGLETON) {
            return this.getCache().getColorSpaceGrayIcc();
        }
        if (colorSpace == PDCSDeviceRGB.SINGLETON) {
            return this.getCache().getColorSpaceRgbIcc();
        }
        if (colorSpace == PDCSDeviceCMYK.SINGLETON) {
            return this.getCache().getColorSpaceCmykIcc();
        }
        return null;
    }

    protected ColorSpaceCache getCache() {
        return ColorSpaceCache.get(this.getPdDoc());
    }

    public PDDocument getPdDoc() {
        return this.pdDoc;
    }

    protected void importCmykIccProfile(PDResources resources) {
        PDColorSpace colorSpace = this.getCache().getColorSpaceCmykIcc();
        if (colorSpace == null) {
            return;
        }
        resources.addColorSpaceResource(PDColorSpace.CN_CS_DefaultCMYK, colorSpace);
    }

    protected void importGrayIccProfile(PDResources resources) {
        PDColorSpace colorSpace = this.getCache().getColorSpaceGrayIcc();
        if (colorSpace == null) {
            return;
        }
        resources.addColorSpaceResource(PDColorSpace.CN_CS_DefaultGray, colorSpace);
    }

    protected void importRgbIccProfile(PDResources resources) {
        PDColorSpace colorSpace = this.getCache().getColorSpaceRgbIcc();
        if (colorSpace == null) {
            return;
        }
        resources.addColorSpaceResource(PDColorSpace.CN_CS_DefaultRGB, colorSpace);
    }

    protected boolean[] parseContent(CSContent contentStream, PDResources resources) {
        final boolean[] missingColorSpaces = new boolean[]{false, false, false};
        CSInterpreter interpreter = new CSInterpreter(null){

            protected CSInterpreterFrame createFrame() {
                return new ExtendedCSInterpreterFrame();
            }

            protected void notSupported(CSOperation operation) throws CSException {
            }

            protected void render_g(CSOperation operation) {
                if (((ExtendedCSInterpreterFrame)this.frame).getDefaultGray() == null) {
                    missingColorSpaces[2] = true;
                }
                super.render_g(operation);
            }

            protected void render_G(CSOperation operation) {
                if (((ExtendedCSInterpreterFrame)this.frame).getDefaultGray() == null) {
                    missingColorSpaces[2] = true;
                }
                super.render_G(operation);
            }

            protected void render_k(CSOperation operation) {
                if (((ExtendedCSInterpreterFrame)this.frame).getDefaultCMYK() == null) {
                    missingColorSpaces[1] = true;
                }
                super.render_k(operation);
            }

            protected void render_K(CSOperation operation) {
                if (((ExtendedCSInterpreterFrame)this.frame).getDefaultCMYK() == null) {
                    missingColorSpaces[1] = true;
                }
                super.render_K(operation);
            }

            protected void render_rg(CSOperation operation) {
                if (((ExtendedCSInterpreterFrame)this.frame).getDefaultRGB() == null) {
                    missingColorSpaces[0] = true;
                }
                super.render_rg(operation);
            }

            protected void render_RG(CSOperation operation) {
                if (((ExtendedCSInterpreterFrame)this.frame).getDefaultRGB() == null) {
                    missingColorSpaces[0] = true;
                }
                super.render_RG(operation);
            }
        };
        try {
            interpreter.process(contentStream, resources);
        }
        catch (CSException cSException) {
            // empty catch block
        }
        return missingColorSpaces;
    }

    public void process() {
        this.process(this.getPdDoc().getPageTree());
    }

    public void process(CSContent contentStream, PDResources resources) {
        COSDictionary xobjects;
        if (resources == null) {
            return;
        }
        boolean[] missingColorSpaces = this.parseContent(contentStream, resources);
        if (missingColorSpaces[0]) {
            this.importRgbIccProfile(resources);
        }
        if (missingColorSpaces[1]) {
            this.importCmykIccProfile(resources);
        }
        if (missingColorSpaces[2]) {
            this.importGrayIccProfile(resources);
        }
        if ((xobjects = resources.cosGetResources(PDResources.CN_RT_XObject)) != null) {
            for (COSObject object : xobjects.values()) {
                PDXObject xobject = (PDXObject)PDXObject.META.createFromCos(object);
                this.process(xobject);
            }
        }
    }

    public void process(PDAcroFormField field) {
        List annotations = field.getAnnotations();
        if (annotations == null) {
            return;
        }
        for (PDAnnotation annotation : annotations) {
            this.process(annotation);
        }
    }

    public void process(PDAnnotation annotation) {
        PDAppearance appearance = annotation.getAppearance();
        if (appearance != null) {
            this.process(appearance);
        }
        if (!annotation.cosGetDict().containsKey(PDAnnotation.DK_F)) {
            AnnotationFlags flags = new AnnotationFlags(annotation);
            flags.setPrint(true);
        }
    }

    public void process(PDAppearance appearance) {
        for (PDForm form : appearance.getForms()) {
            this.process(form);
        }
    }

    public void process(PDForm form) {
        this.process(form.getContentStream(), form.getResources());
    }

    public void process(PDImage image) {
        PDColorSpace colorSpace = image.getColorSpace();
        PDColorSpace fixed = this.fixColorSpace(colorSpace);
        if (fixed != null) {
            image.cosSetColorSpace(fixed.cosGetObject().asArray());
        }
    }

    public void process(PDPage page) {
        CSContent contentStream = page.getContentStream();
        PDResources resources = page.getResources();
        this.process(contentStream, resources);
        if (page.getAnnotations() != null) {
            for (PDAnnotation anno : page.getAnnotations()) {
                this.process(anno);
            }
        }
    }

    public void process(PDPageTree pageTree) {
        for (PDPage page = pageTree.getFirstPage(); page != null; page = page.getNextPage()) {
            this.process(page);
        }
    }

    public void process(PDXObject xobject) {
        if (xobject.isForm()) {
            this.process((PDForm)xobject);
        } else if (xobject.isImage()) {
            this.process((PDImage)xobject);
        } else {
            this.basicProcess(xobject);
        }
    }

    public static class ExtendedCSInterpreterFrame
    extends CSInterpreterFrame {
        protected PDColorSpace getDefaultCMYK() {
            return this.defaultCMYK;
        }

        protected PDColorSpace getDefaultGray() {
            return this.defaultGray;
        }

        protected PDColorSpace getDefaultRGB() {
            return this.defaultRGB;
        }

        protected PDResources getResources() {
            return this.resources;
        }
    }
}

