/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.endorsement;

import de.intarsys.pdf.app.endorsement.PACKAGE;
import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.expression.ThreadContextAwareResolver;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;

public class EndorsementEvidence {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private long timestamp;
    private Object data;
    private float height;
    private float width;
    private float x;
    private float y;
    private int page;
    private EnumAlignment hAlign;
    private EnumAlignment vAlign;
    private String title;
    private String label;
    private String description;

    public static EndorsementEvidence createFromArgs(IArgs args) {
        if (args == null || args.size() == 0) {
            return null;
        }
        EndorsementEvidence result = new EndorsementEvidence();
        result.setTitle(ArgTools.getString((IArgs)args, (String)"title", null));
        result.setLabel(ArgTools.getString((IArgs)args, (String)"label", null));
        result.setDescription(ArgTools.getString((IArgs)args, (String)"description", null));
        result.setTimestamp(ArgTools.getLongStrict((IArgs)args, (String)"timestamp", (long)0L));
        result.setData(ArgTools.getObject((IArgs)args, (String)"data", null));
        result.setHeight(ArgTools.getFloatStrict((IArgs)args, (String)"height", (float)100.0f));
        result.setPage(ArgTools.getIntStrict((IArgs)args, (String)"page", (int)0));
        result.setWidth(ArgTools.getFloatStrict((IArgs)args, (String)"width", (float)100.0f));
        result.setX(ArgTools.getFloatStrict((IArgs)args, (String)"x", (float)0.0f));
        result.setY(ArgTools.getFloatStrict((IArgs)args, (String)"y", (float)0.0f));
        result.setHAlign(EnumAlignment.createFromArgs((IArgs)args, (String)"hAlign", null));
        result.setVAlign(EnumAlignment.createFromArgs((IArgs)args, (String)"vAlign", null));
        return result;
    }

    public Object getData() {
        return this.data;
    }

    public String getDefaultDescription() {
        return this.evaluateMessageInContextOfEndorsement("EndorsementEvidence.description");
    }

    public String getDefaultLabel() {
        return this.evaluateMessageInContextOfEndorsement("EndorsementEvidence.label");
    }

    public String getDefaultTitle() {
        return this.evaluateMessageInContextOfEndorsement("EndorsementEvidence.title");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String evaluateMessageInContextOfEndorsement(String key) {
        String template = Msg.getString(key, new Object[0]);
        MapResolver resolver = MapResolver.createStrict((String)"endorsement", (IStringEvaluator)new ReflectiveResolver((Object)this));
        ThreadContextAwareResolver.attach((IStringEvaluator)resolver);
        try {
            String string = TemplateEvaluator.evaluateString((Mode)Mode.TRUSTED, (String)template);
            return string;
        }
        finally {
            ThreadContextAwareResolver.detach((IStringEvaluator)resolver);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public EnumAlignment getHAlign() {
        return this.hAlign;
    }

    public float getHeight() {
        return this.height;
    }

    public String getLabel() {
        return this.label;
    }

    public int getPage() {
        return this.page;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTitle() {
        return this.title;
    }

    public EnumAlignment getVAlign() {
        return this.vAlign;
    }

    public float getWidth() {
        return this.width;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHAlign(EnumAlignment hAlign) {
        this.hAlign = hAlign;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVAlign(EnumAlignment vAlign) {
        this.vAlign = vAlign;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }
}

