/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.files;

import de.intarsys.pdf.app.files.EmbeddedFiles;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDFileSpecification;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.presentation.IPresentationSupport;

public class EmbeddedFile
implements IAttributeSupport,
IPresentationSupport {
    private PDDocument doc;
    private COSString name;
    private PDFileSpecification fileSpecification;
    private AttributeMap attributes = new AttributeMap();

    public EmbeddedFile(COSString name, PDFileSpecification fileSpecification, PDDocument doc) {
        this.name = name;
        this.fileSpecification = fileSpecification;
        this.doc = doc;
    }

    public void delete() {
        this.getEmbeddedFiles().removeFile(this.getName());
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public String getDescription() {
        return this.getFileSpecification().getDescription();
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    protected EmbeddedFiles getEmbeddedFiles() {
        return EmbeddedFiles.get(this.getDoc());
    }

    public PDFileSpecification getFileSpecification() {
        return this.fileSpecification;
    }

    public String getIconName() {
        return "document";
    }

    public String getLabel() {
        return this.getName().stringValue();
    }

    public COSString getName() {
        return this.name;
    }

    public String getTip() {
        return this.getDescription();
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setFileSpecification(PDFileSpecification fileSpecification) {
        this.fileSpecification = fileSpecification;
        this.getEmbeddedFiles().removeFile(this.getName());
        this.getEmbeddedFiles().addFile(this.getName(), this.getFileSpecification());
    }

    public void setName(COSString name) {
        this.getEmbeddedFiles().removeFile(this.getName());
        this.name = name;
        this.getEmbeddedFiles().addFile(this.getName(), this.getFileSpecification());
    }
}

