/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.files;

import de.intarsys.pdf.app.files.EmbeddedFile;
import de.intarsys.pdf.cds.CDSNameTreeEntry;
import de.intarsys.pdf.cds.CDSNameTreeNode;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDFileSpecification;
import de.intarsys.tools.attribute.Attribute;
import java.util.ArrayList;
import java.util.List;

public class EmbeddedFiles {
    private static final Attribute ATTR_EMBEDDEDFILES = new Attribute("EmbeddedFiles");
    private PDDocument doc;

    public static EmbeddedFiles get(PDDocument doc) {
        EmbeddedFiles embeddedFiles = (EmbeddedFiles)doc.getAttribute((Object)ATTR_EMBEDDEDFILES);
        if (embeddedFiles == null) {
            embeddedFiles = new EmbeddedFiles(doc);
            doc.setAttribute((Object)ATTR_EMBEDDEDFILES, (Object)embeddedFiles);
        }
        return embeddedFiles;
    }

    protected EmbeddedFiles(PDDocument doc) {
        this.doc = doc;
    }

    public void addFile(COSString name, PDFileSpecification fileSpecification) {
        CDSNameTreeNode tree;
        COSDictionary names = this.getDoc().getCatalog().cosGetNames();
        if (names == null) {
            names = COSDictionary.create();
            this.getDoc().getCatalog().cosSetField(COSCatalog.DK_Names, (COSObject)names);
        }
        if ((tree = CDSNameTreeNode.createFromCos((COSDictionary)names.get(COSCatalog.DK_EmbeddedFiles).asDictionary())) == null) {
            tree = CDSNameTreeNode.createRootLeaf();
            names.put(COSCatalog.DK_EmbeddedFiles, tree.cosGetObject());
        }
        tree.put(name, fileSpecification.cosGetObject());
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public EmbeddedFile getFile(COSString name) {
        COSDictionary names = this.getDoc().getCatalog().cosGetNames();
        if (names == null) {
            return null;
        }
        CDSNameTreeNode tree = CDSNameTreeNode.createFromCos((COSDictionary)names.get(COSCatalog.DK_EmbeddedFiles).asDictionary());
        if (tree == null) {
            return null;
        }
        COSObject cosFileSpec = tree.get(name);
        if (cosFileSpec.isNull()) {
            return null;
        }
        PDFileSpecification fileSpec = (PDFileSpecification)PDFileSpecification.META.createFromCos(cosFileSpec);
        return new EmbeddedFile(name, fileSpec, this.getDoc());
    }

    public List<EmbeddedFile> getFiles() {
        CDSNameTreeNode tree;
        ArrayList<EmbeddedFile> embeddedFiles = new ArrayList<EmbeddedFile>();
        COSDictionary names = this.getDoc().getCatalog().cosGetNames();
        if (names != null && (tree = CDSNameTreeNode.createFromCos((COSDictionary)names.get(COSCatalog.DK_EmbeddedFiles).asDictionary())) != null) {
            for (CDSNameTreeEntry entry : tree) {
                PDFileSpecification fileSpec = (PDFileSpecification)PDFileSpecification.META.createFromCos(entry.getValue());
                embeddedFiles.add(new EmbeddedFile(entry.getName(), fileSpec, this.getDoc()));
            }
        }
        return embeddedFiles;
    }

    public void removeFile(COSString name) {
        COSDictionary names = this.getDoc().getCatalog().cosGetNames();
        if (names == null) {
            return;
        }
        CDSNameTreeNode tree = CDSNameTreeNode.createFromCos((COSDictionary)names.get(COSCatalog.DK_EmbeddedFiles).asDictionary());
        if (tree == null) {
            return;
        }
        tree.remove(name);
    }
}

