/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.files;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDEmbeddedFile;
import de.intarsys.pdf.pd.PDFileSpecification;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class FileSpecificationTools {
    private static final Attribute ATTR_LOCATOR = new Attribute("locator");

    private static ILocator createLocator(PDFileSpecification fs) throws IOException {
        ILocator iLocator;
        COSName flavor = PDFileSpecification.DK_F;
        String fss = fs.getFileSpecificationString(flavor);
        if (fss == null) {
            flavor = PDFileSpecification.CN_F_DOS;
            fss = fs.getFileSpecificationString(flavor);
        }
        OutputStream os = null;
        try {
            ILocator fileLocator;
            PDEmbeddedFile ef = fs.getEmbeddedFile(flavor);
            File tempFile = TempTools.createTempFile((String)"", (String)fss);
            tempFile.deleteOnExit();
            os = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);
            os.write(ef.getBytes());
            iLocator = fileLocator = LocatorFactory.get().createLocator(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            try {
                Reporter.get().reportMessage("File Attachment", "can not open file", 0);
                throw e;
            }
            catch (Throwable throwable) {
                StreamTools.close(os);
                throw throwable;
            }
        }
        StreamTools.close((Closeable)os);
        return iLocator;
    }

    public static ILocator getLocator(PDFileSpecification fs) throws IOException {
        ILocator locator = (ILocator)fs.getAttribute((Object)ATTR_LOCATOR);
        if (locator == null) {
            locator = FileSpecificationTools.createLocator(fs);
            fs.setAttribute((Object)ATTR_LOCATOR, (Object)locator);
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(PDFileSpecification fs, ILocator locator) throws IOException {
        COSName flavor = PDFileSpecification.DK_F;
        String fss = fs.getFileSpecificationString(flavor);
        if (fss == null) {
            flavor = PDFileSpecification.CN_F_DOS;
            fss = fs.getFileSpecificationString(flavor);
        }
        if (fss == null) {
            return;
        }
        OutputStream os = null;
        try {
            os = locator.getOutputStream();
            PDEmbeddedFile ef = fs.getEmbeddedFile(flavor);
            os.write(ef.getBytes());
        }
        finally {
            StreamTools.close((Closeable)os);
        }
    }

    private FileSpecificationTools() {
    }
}

