/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.font;

import de.intarsys.pdf.content.CSVirtualDevice;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.pdf.tools.kernel.PDFParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class CSFontUseScanner
extends CSVirtualDevice {
    private Map<PDFont, Collection<PDGlyphs>> usedGlyphsByFont;

    public CSFontUseScanner(Map<PDFont, Collection<PDGlyphs>> usedGlyphsByFont) {
        this.usedGlyphsByFont = usedGlyphsByFont;
    }

    public void doXObject(COSName name, PDXObject xobject) {
    }

    private Collection<PDGlyphs> getUsedGlyphs(PDFont font) {
        return this.usedGlyphsByFont.computeIfAbsent(font, key -> new HashSet());
    }

    public void textShow(byte[] text, int offset, int length) {
        if (this.graphicsState.textState.renderingMode == 3) {
            return;
        }
        PDFont font = this.graphicsState.textState.font;
        Collection<PDGlyphs> usedGlyphs = this.getUsedGlyphs(font);
        ByteArrayInputStream stream = new ByteArrayInputStream(text);
        try {
            PDGlyphs glyph;
            while ((glyph = font.getNextGlyphsEncoded(stream)) != null) {
                usedGlyphs.add(glyph);
            }
        }
        catch (UnsupportedOperationException glyph) {
        }
        catch (IOException exception) {
            throw new PDFParseException("should never happen while reading from a byte array", (Throwable)exception);
        }
    }
}

