/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.font;

import de.intarsys.pdf.app.font.CSFontUseScanner;
import de.intarsys.pdf.app.font.FontEmbedder;
import de.intarsys.pdf.app.font.FontException;
import de.intarsys.pdf.app.font.SilentCSExceptionHandler;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.ICSExceptionHandler;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDResources;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;

public class DocumentWideFontEmbedder {
    private PDDocument document;
    private FontEmbedder delegate;

    public DocumentWideFontEmbedder(PDDocument document) {
        this.document = document;
    }

    public void embedFonts() throws FontException {
        this.delegate = new FontEmbedder();
        this.visitDocument(this.document);
        this.delegate.embedFonts();
    }

    private void visitDocument(PDDocument document) {
        HashSet<IContentStreamProvider> visited = new HashSet<IContentStreamProvider>();
        PDPageTree pageTree = document.getPageTree();
        for (PDPage page = pageTree.getFirstPage(); page != null; page = page.getNextPage()) {
            this.visitContentStreamProvider(visited, (IContentStreamProvider)page);
            this.visitAnnotations(visited, page);
        }
    }

    private void visitContentStreamProvider(Collection<IContentStreamProvider> visited, IContentStreamProvider contentStreamProvider) {
        if (!visited.add(contentStreamProvider)) {
            return;
        }
        PDResources resources = contentStreamProvider.getResources();
        if (resources == null) {
            return;
        }
        this.scanUsedFonts(contentStreamProvider);
        Stream.concat(this.getResourceContentStreamProviders(resources, PDResources.CN_RT_XObject, (PDObject.MetaClass)PDForm.META), this.getResourceContentStreamProviders(resources, PDResources.CN_RT_Pattern, (PDObject.MetaClass)PDPattern.META)).forEach(cp -> this.visitContentStreamProvider(visited, (IContentStreamProvider)cp));
    }

    private Stream<IContentStreamProvider> getResourceContentStreamProviders(PDResources resources, COSName resourceType, PDObject.MetaClass metaClass) {
        COSDictionary subdictionary = resources.cosGetResources(resourceType);
        if (subdictionary == null) {
            return Stream.empty();
        }
        List values = subdictionary.values();
        return values.stream().map(arg_0 -> ((PDObject.MetaClass)metaClass).createFromCos(arg_0)).filter(IContentStreamProvider.class::isInstance).map(IContentStreamProvider.class::cast);
    }

    private void visitAnnotations(Collection<IContentStreamProvider> visited, PDPage page) {
        List annotations = page.getAnnotations();
        if (annotations == null) {
            return;
        }
        for (PDAnnotation annotation : annotations) {
            PDAppearance appearance = annotation.getAppearance();
            if (appearance == null) continue;
            for (PDForm form : appearance.getForms()) {
                this.visitContentStreamProvider(visited, (IContentStreamProvider)form);
            }
        }
    }

    private void scanUsedFonts(IContentStreamProvider contentStreamProvider) {
        HashMap<PDFont, Collection<PDGlyphs>> fontToUsedGlyphs = new HashMap<PDFont, Collection<PDGlyphs>>();
        CSFontUseScanner scanner = new CSFontUseScanner(fontToUsedGlyphs);
        CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(Collections.emptyMap(), (ICSDevice)scanner);
        interpreter.setExceptionHandler((ICSExceptionHandler)new SilentCSExceptionHandler());
        interpreter.process(contentStreamProvider.getContentStream(), contentStreamProvider.getResources());
        fontToUsedGlyphs.forEach((font, usedGlyphs) -> {
            if (!font.isEmbedded()) {
                this.delegate.registerFontWithGlyphs((PDFont)font, (Collection<PDGlyphs>)usedGlyphs);
            }
        });
    }
}

