/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.font;

import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontProgram;
import de.intarsys.cwt.font.IFontQuery;
import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.cwt.font.truetype.TTFontSubsetter;
import de.intarsys.cwt.font.type1.PFB;
import de.intarsys.pdf.app.font.FontException;
import de.intarsys.pdf.app.font.FontQuery;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.font.FontDescriptorFlags;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FontEmbedder {
    private static final String TYPE_TRUE_TYPE = "TrueType";
    private static final String TYPE_TYPE_1 = "Type1";
    private static final COSName[] LENGTH_KEYS = new COSName[]{PDFontDescriptorEmbedded.DK_Length1, PDFontDescriptorEmbedded.DK_Length2, PDFontDescriptorEmbedded.DK_Length3};
    private static final int SUBSET_TAG_LENGTH = 6;
    private Map<IFontQuery, Collection<PDFont>> fontQueryToFonts = new HashMap<IFontQuery, Collection<PDFont>>();
    private Map<IFontQuery, Collection<Integer>> fontQueryToUsedCharacters = new HashMap<IFontQuery, Collection<Integer>>();
    private boolean subsetting = true;

    private Metrics computeMetrics(PDFont font, Collection<Integer> characters) throws FontException {
        IntSummaryStatistics statistics = characters.stream().mapToInt(arg_0 -> ((Encoding)font.getEncoding()).getEncoded(arg_0)).filter(cp -> cp != -1).summaryStatistics();
        int firstChar = 0;
        int lastChar = 0;
        if (statistics.getCount() > 0L) {
            firstChar = statistics.getMin();
            lastChar = statistics.getMax();
        }
        try {
            COSArray widths = COSArray.create((int)(lastChar - firstChar + 1));
            widths.beIndirect();
            IPlatformFont platformFont = PlatformFontFactory.get().createPlatformFont(font);
            for (int codePoint = firstChar; codePoint <= lastChar; ++codePoint) {
                PDGlyphs glyph = font.getGlyphsEncoded(codePoint);
                IPlatformGlyphs platformGlyph = platformFont.createPlatformGlyphs(glyph);
                int width = platformGlyph.getWidth();
                widths.add((COSObject)COSInteger.create((int)width));
            }
            return new Metrics(firstChar, lastChar, widths);
        }
        catch (PlatformFontException exception) {
            throw new FontException("Failed to compute font metrics: " + font, exception);
        }
    }

    private String computeSubsetPrefix(Collection<Integer> characters) {
        int hash = characters.stream().mapToInt(Integer::intValue).sorted().reduce(0, (a, b) -> a * 31 + b);
        hash &= Integer.MAX_VALUE;
        char[] tag = new char[6];
        for (int i = tag.length - 1; i >= 0; --i) {
            tag[i] = (char)(65 + hash % 26);
            hash /= 26;
        }
        return new String(tag);
    }

    private PDFontDescriptor createFontDescriptor(PDFont font) throws FontException {
        IPlatformFont platformFont;
        try {
            platformFont = PlatformFontFactory.get().createPlatformFont(font);
        }
        catch (PlatformFontException exception) {
            throw new FontException("Failed to create font descriptor: " + font, exception);
        }
        PDFontDescriptorEmbedded descriptor = (PDFontDescriptorEmbedded)PDFontDescriptorEmbedded.META.createNew();
        descriptor.setFontName(font.getBaseFont().stringValue());
        descriptor.setFontBB(new CDSRectangle(platformFont.getBBox()));
        descriptor.setAscent(platformFont.getAscent());
        descriptor.setDescent(platformFont.getDescent());
        FontDescriptorFlags flags = descriptor.getFlags();
        flags.setSymbolic(platformFont.isSymbolFont());
        flags.setItalic(platformFont.isItalicStyle());
        flags.setFixedPitch(platformFont.isMonospaced());
        descriptor.setCapHeight(platformFont.getHeight());
        descriptor.setItalicAngle(platformFont.isItalicStyle() ? -10.0f : 0.0f);
        descriptor.setStemV((int)Math.round(platformFont.getBBox().getWidth() * 0.1));
        return descriptor;
    }

    private COSStream createStream(byte[] data, int[] lengths) {
        COSDictionary dictionary = COSDictionary.create();
        for (int i = 0; i < lengths.length; ++i) {
            dictionary.put(LENGTH_KEYS[i], (COSObject)COSInteger.create((int)lengths[i]));
        }
        COSStream stream = COSStream.create((COSDictionary)dictionary);
        stream.addFilter(Filter.CN_Filter_FlateDecode);
        stream.setDecodedBytes(data);
        return stream;
    }

    private COSStream createTrueTypeFontFile(TTFont ttFont) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new TTFontSerializer().write((OutputStream)output, ttFont);
            byte[] data = output.toByteArray();
            COSStream cOSStream = this.createStream(data, new int[]{data.length});
            return cOSStream;
        }
    }

    private COSStream createType1FontFile(PFB pfb) {
        return this.createStream(pfb.getStrippedData(), new int[]{pfb.getLength1(), pfb.getLength2(), 0});
    }

    public void embedFonts() throws FontException {
        block8: for (Map.Entry<IFontQuery, Collection<PDFont>> entry : this.fontQueryToFonts.entrySet()) {
            IFontQuery fontQuery = entry.getKey();
            Collection<Integer> usedCharacters = this.fontQueryToUsedCharacters.get(fontQuery);
            Collection<PDFont> fonts = entry.getValue();
            switch (fontQuery.getFontType()) {
                case "Type1": {
                    this.embedType1Font(fontQuery, usedCharacters, fonts);
                    continue block8;
                }
                case "TrueType": {
                    this.embedTrueTypeFont(fontQuery, usedCharacters, fonts);
                    continue block8;
                }
            }
            throw new FontException("Unsupported font type: " + fontQuery);
        }
    }

    private void embedTrueTypeFont(IFontQuery fontQuery, Collection<Integer> characters, Collection<PDFont> fonts) throws FontException {
        COSStream fontFile;
        TTFont ttFont;
        IFont cwtFont = this.lookupFont(fontQuery);
        ILocator locator = cwtFont.getFontProgram().getLocator();
        try {
            ttFont = TTFont.createFromLocator((ILocator)locator);
        }
        catch (TTException | IOException exception) {
            throw new FontException("Failed to read TrueType font: " + locator, exception);
        }
        try {
            if (!ttFont.isEmbeddingPermitted()) {
                throw new FontException("Font does mot permit embedding: " + ttFont);
            }
        }
        catch (TTException exception) {
            throw new FontException("Failed to check embedding license rights", exception);
        }
        Object fontName = cwtFont.getFontNamePostScript();
        try {
            if (this.subsetting && ttFont.isSubsettingPermitted()) {
                fontName = this.computeSubsetPrefix(characters) + "+" + (String)fontName;
                ttFont = this.subsetTrueTypeFont(ttFont, characters);
            }
        }
        catch (TTException | IOException exception) {
            throw new FontException("Failed to subset TrueType font: " + fontQuery, exception);
        }
        try {
            fontFile = this.createTrueTypeFontFile(ttFont);
        }
        catch (IOException exception) {
            throw new FontException("Failed to serialize TrueType font: " + fontQuery, exception);
        }
        for (PDFont font : fonts) {
            PDFontDescriptor fontDescriptor = font.getFontDescriptor();
            if (fontDescriptor == null) {
                fontDescriptor = this.createFontDescriptor(font);
                font.setFontDescriptor(fontDescriptor);
            }
            fontDescriptor.cosSetField(PDFontDescriptorEmbedded.DK_FontFile2, (COSObject)fontFile);
            font.setBaseFont((String)fontName);
            fontDescriptor.setFontName((String)fontName);
        }
    }

    private void embedType1Font(IFontQuery fontQuery, Collection<Integer> characters, Collection<PDFont> fonts) throws FontException {
        PFB pfb;
        byte[] data;
        IFont cwtFont = this.lookupFont(fontQuery);
        String fontName = cwtFont.getFontNamePostScript();
        ILocator locator = cwtFont.getFontProgram().getLocator();
        try {
            data = LocatorTools.getBytes((ILocator)locator);
        }
        catch (IOException exception) {
            throw new FontException("Failed to read Type 1 font program: " + locator, exception);
        }
        try {
            pfb = PFB.from((byte[])data);
        }
        catch (IllegalArgumentException exception) {
            throw new FontException("Malformed Type 1 font program: " + locator, exception);
        }
        COSStream fontFile = this.createType1FontFile(pfb);
        HashMap<Encoding, Metrics> encodingToMetrics = new HashMap<Encoding, Metrics>();
        for (PDFont font : fonts) {
            font.cosSetSubtype(PDFont.CN_Subtype_Type1);
            PDFontDescriptor fontDescriptor = font.getFontDescriptor();
            if (fontDescriptor == null || fontDescriptor.isBuiltin()) {
                fontDescriptor = this.createFontDescriptor(font);
                font.setFontDescriptor(fontDescriptor);
            }
            fontDescriptor.cosSetField(PDFontDescriptorEmbedded.DK_FontFile, (COSObject)fontFile);
            fontDescriptor.setFontName(fontName);
            font.setBaseFont(fontName);
            Encoding encoding = font.getEncoding();
            Metrics metrics = (Metrics)encodingToMetrics.get(encoding);
            if (metrics == null) {
                metrics = this.computeMetrics(font, characters);
                encodingToMetrics.put(encoding, metrics);
            }
            metrics.applyTo(font);
        }
    }

    private <K, V> Collection<V> getOrCreateCollection(Map<K, Collection<V>> multiValueMap, K key) {
        return multiValueMap.computeIfAbsent(key, k -> new HashSet());
    }

    public boolean isSubsetting() {
        return this.subsetting;
    }

    private IFont lookupFont(IFontQuery fontQuery) throws FontException {
        String actualFontType;
        IFont cwtFont = FontTools.lookupFont((IFontQuery)fontQuery);
        if (cwtFont == null) {
            throw new FontException("No matching font registered: " + fontQuery);
        }
        String expectedFontType = fontQuery.getFontType();
        if (!Objects.equals(expectedFontType, actualFontType = cwtFont.getFontType())) {
            throw new FontException(String.format("Registered font has wrong type (%s vs. %s): %s", expectedFontType, actualFontType, fontQuery));
        }
        IFontProgram fontProgram = cwtFont.getFontProgram();
        if (fontProgram == null || fontProgram.getLocator() == null) {
            throw new FontException("Missing font program: " + fontQuery);
        }
        return cwtFont;
    }

    public void registerFont(PDFont font) {
        int firstChar = font.getFirstChar();
        int lastChar = font.getLastChar();
        List<Integer> characters = IntStream.rangeClosed(firstChar, lastChar).boxed().toList();
        this.registerFontWithCharacters(font, characters);
    }

    public void registerFontWithCharacters(PDFont font, Collection<Integer> usedCharacters) {
        FontQuery fontQuery = FontQuery.from(font);
        this.getOrCreateCollection(this.fontQueryToFonts, fontQuery).add(font);
        this.getOrCreateCollection(this.fontQueryToUsedCharacters, fontQuery).addAll(usedCharacters);
    }

    public void registerFontWithGlyphs(PDFont font, Collection<PDGlyphs> usedGlyphs) {
        Collection usedCharacters = usedGlyphs.stream().map(PDGlyphs::getDecoded).filter(c -> c != -1).collect(Collectors.toSet());
        this.registerFontWithCharacters(font, usedCharacters);
    }

    public void setSubsetting(boolean subsetting) {
        this.subsetting = subsetting;
    }

    private TTFont subsetTrueTypeFont(TTFont ttFont, Collection<Integer> characters) throws TTException, IOException {
        return TTFontSubsetter.builder((TTFont)ttFont).withCids(characters).withPreferredCMap().build().createSubset();
    }

    private static class Metrics {
        private int firstChar;
        private int lastChar;
        private COSArray widths;

        public Metrics(int firstChar, int lastChar, COSArray widths) {
            this.firstChar = firstChar;
            this.lastChar = lastChar;
            this.widths = widths;
        }

        public void applyTo(PDFont font) {
            font.setFieldInt(PDFont.DK_FirstChar, this.firstChar);
            font.setFieldInt(PDFont.DK_LastChar, this.lastChar);
            font.cosSetField(PDFont.DK_Widths, (COSObject)this.widths);
        }
    }
}

