/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.font;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFontQuery;
import de.intarsys.pdf.font.PDFont;
import java.util.Objects;

public class FontQuery
implements IFontQuery {
    private String type;
    private String familyName;
    private String name;
    private FontStyle style;
    private String canonicalName;
    private int hashCode;

    public static FontQuery from(PDFont font) {
        String type = font.getFontType();
        String name = font.getFontNameNormalized();
        String familyName = font.getFontFamilyName();
        if (familyName == null) {
            familyName = FontTools.getFontFamilyName((String)name);
        }
        FontStyle style = FontStyle.getFontStyle((String)font.getFontStyle().getLabel());
        String canonicalName = FontTools.createCanonicalName((String)familyName, (String)style.getId());
        return new FontQuery(type, familyName, name, style, canonicalName);
    }

    public FontQuery(String type, String familyName, String name, FontStyle style, String canonicalName) {
        this.type = type;
        this.familyName = familyName;
        this.name = name;
        this.style = style;
        this.canonicalName = canonicalName;
    }

    public String getFontFamilyName() {
        return this.familyName;
    }

    public String getFontName() {
        return this.name;
    }

    public Object getFontNameCanonical() {
        return this.canonicalName;
    }

    public FontStyle getFontStyle() {
        return this.style;
    }

    public String getFontType() {
        return this.type;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.type, this.familyName, this.name, this.canonicalName, this.style);
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        FontQuery otherQuery = (FontQuery)other;
        return Objects.equals(otherQuery.type, this.type) && Objects.equals(otherQuery.familyName, this.familyName) && Objects.equals(otherQuery.name, this.name) && Objects.equals(otherQuery.canonicalName, this.canonicalName) && otherQuery.style == this.style;
    }

    public String toString() {
        return String.format("FontQuery(type=%s, familyName=%s, name=%s, canonicalName=%s, style=%s)", this.type, this.familyName, this.name, this.canonicalName, this.style);
    }
}

