/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.font;

import de.intarsys.pdf.app.font.CSUsedCharacterCollector;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.PDFontTrueTypeTools;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class SubsetFontTools {
    private static final String ATTR_FONT_DEDICATED = "dedicated";
    private static final Attribute ATTR_USED = new Attribute("used");

    public static Set<PDGlyphs> getUsedGlyphs(IAttributeSupport as) {
        return (Set)as.getAttribute((Object)ATTR_USED);
    }

    public static boolean isDedicated(PDFont font) {
        return Boolean.TRUE.equals(font.getAttribute((Object)ATTR_FONT_DEDICATED));
    }

    public static void setDedicated(PDFont font, boolean value) {
        font.setAttribute((Object)ATTR_FONT_DEDICATED, (Object)value);
    }

    public static void setUsedGlyphs(IAttributeSupport as, Set<PDGlyphs> used) {
        as.setAttribute((Object)ATTR_USED, used);
    }

    public static void subsetDedicatedFont(PDFont font, CSCreator creator) {
        if (SubsetFontTools.isDedicated(font)) {
            if (PDFontTrueTypeTools.isTrueTypeBased((PDFont)font)) {
                CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(Collections.emptyMap(), (ICSDevice)new CSUsedCharacterCollector());
                interpreter.process(creator.getContent(), creator.getResourcesProvider().getResources());
                try {
                    PDFontTrueTypeTools.subset((PDFont)font, SubsetFontTools.getUsedGlyphs((IAttributeSupport)font));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            font.removeAttribute((Object)ATTR_FONT_DEDICATED);
        }
    }
}

