/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.font;

import de.intarsys.pdf.app.common.CommonPDFFunctor;
import de.intarsys.pdf.app.font.CSUsedCharacterCollector;
import de.intarsys.pdf.app.font.SubsetFontTools;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.platform.cwt.font.PDFontTrueTypeTools;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IArgs;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SubsetTTFontsUsedCharacters
extends CommonPDFFunctor {
    @Override
    protected Object basicPerform(PDDocument doc, IArgs args) throws FunctorException {
        this.collectCharacters(doc);
        this.checkFonts(doc);
        return null;
    }

    protected void checkFonts(PDDocument doc) throws FunctorException {
        Iterator it = doc.cosGetDoc().objects();
        while (it.hasNext()) {
            Set<PDGlyphs> used;
            PDFont font;
            COSDictionary dict = ((COSObject)it.next()).asDictionary();
            if (dict == null) continue;
            try {
                font = (PDFont)PDFont.META.createFromCos((COSObject)dict);
            }
            catch (Exception e) {
                continue;
            }
            if (font == null || (used = SubsetFontTools.getUsedGlyphs((IAttributeSupport)font)) == null || !(font instanceof PDFontTrueType)) continue;
            try {
                PDFontTrueTypeTools.subset((PDFont)font, used);
            }
            catch (Exception e) {
                throw new FunctorExecutionException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectCharacters(PDDocument doc) {
        PDPage page = doc.getPageTree().getFirstPage();
        CSUsedCharacterCollector device = new CSUsedCharacterCollector();
        while (page != null) {
            try {
                CSContent content = page.getContentStream();
                if (content != null) {
                    CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(new HashMap(), (ICSDevice)device);
                    interpreter.process(content, page.getResources());
                }
                List annots = page.getAnnotations();
                for (PDAnnotation annot : annots) {
                    PDAppearance appearance = annot.getAppearance();
                    List forms = appearance.getForms();
                    for (PDForm form : forms) {
                        CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(new HashMap(), (ICSDevice)device);
                        interpreter.process(form.getContentStream(), form.getResources());
                    }
                }
            }
            catch (Exception exception) {}
            continue;
            finally {
                page = page.getNextPage();
            }
        }
    }
}

